/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardstep2conversion.h"

CWizardStep2Conversion::CWizardStep2Conversion(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	//Aditionnal init
  QLabel_1->setBackgroundPixmap(QPixmap(Icon("karchiveur_wizard.xpm")));	
  setCaption(i18n("Conversion wizard step 3"));

	connect(boutonPrecedent, SIGNAL(clicked()), SLOT(reject()));
	connect(boutonSuivant, SIGNAL(clicked()), SLOT(choixRepertoire()));
}

CWizardStep2Conversion::~CWizardStep2Conversion(){
}

/** Choose a directory where to store the arrchive */
void CWizardStep2Conversion::choixRepertoire()
{
	QDir rep;
		
	if(radiotar->isChecked())
		type=0;
	else if(radiotargz->isChecked())
		type=1;
	else if(radiotarbz2->isChecked())
		type=2;
	else if(radiozip->isChecked())
		type=3;
	else if(radiogz->isChecked())
		type=4;
	else if(radiobz2->isChecked())
		type=5;
											
	repconv=KDirDialog::getDirectory(QDir::homeDirPath());
	rep.setPath((const char*)repconv);
	if(rep.isReadable())
		accept();
	else
		reject();
}

/** Choose a directory where to store the arrchive */
void CWizardStep2Conversion::setParametre(const char* nomarch)
{
	QString archive;
	
	archive=nomarch;
	archive=archive.lower();
	
	if((archive.right(7)==".tar.gz")||(archive.right(6)==".tar.z")||(archive.right(4)==".tgz"))
	{
		radiotargz->setEnabled(false);
		radiogz->setEnabled(false);
		radiobz2->setEnabled(false);
		radiotarbz2->setChecked(true);
	}
	else if(archive.right(8)==".tar.bz2")
	{
		radiotarbz2->setEnabled(false);
		radiogz->setEnabled(false);
		radiobz2->setEnabled(false);
		radiotargz->setChecked(true);
	}
	else if(archive.right(4)==".tar")
	{
		radiotar->setEnabled(false);
		radiogz->setEnabled(false);
		radiobz2->setEnabled(false);
		radiotarbz2->setChecked(true);
	}
	else if(archive.right(4)==".zip")
	{
		radiozip->setEnabled(false);
		radiogz->setEnabled(false);
		radiobz2->setEnabled(false);
		radiotarbz2->setChecked(true);
	}
	else if(archive.right(3)==".gz")
	{
		radiogz->setEnabled(false);
		radiobz2->setEnabled(true);
	}
	else if(archive.right(4)==".bz2")
	{
		radiobz2->setEnabled(false);
		radiogz->setEnabled(true);
	}
}