/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cscript.h"

CScript::CScript()
{
}

CScript::~CScript()
{
}

/* Start the wizard operations)*/
int CScript::demarrerAssistant(const char* cfichselect, const char* crepbase, const char* nomarch)
{
	fichselect=cfichselect;
	repbase=crepbase;
	nomarchive=nomarch;
	return assistantUn();
}

/** show the first wizard */
int CScript::assistantUn()
{
	if(objAssistUn.exec())
	{
		if(objAssistUn.getTypeOperation()==0)
		{
			//It's a patch
			assistantUnPatch();
			return 0;
		}
		else if(objAssistUn.getTypeOperation()==1)
		{
			 //It's an installation
			assistantUnInstall();
			return 1;
		}
		else if(objAssistUn.getTypeOperation()==2)
		{
			//It's a conversion
			return assistantUnConversion();
		}
		else if(objAssistUn.getTypeOperation()==-1)
		{
			//It's a split
			return assistantUnCutt();
		}
	}
	return -1;
}

/** Show the second wizard */
void CScript::assistantDeux()
{
	if(objAssistDeux.exec())
	{
		assistantDeuxInstall();
	}
	else
		assistantUn();
}

/** Show the third wizard */
void CScript::faireInstallation()
{
  objAssistTrois.fichselect=fichselect;
  objAssistTrois.repbase=repbase;
  objAssistTrois.setOperation(1);
  objAssistTrois.setParametres(objAssistDeux.leconfigure->text(),
  															objAssistDeux.learguments->text(),
  															objAssistDeux.lemake->text(),
  															(objAssistDeux.lemakeinstall->text()),
  															objAssistDeux.typeInstall);
	objAssistTrois.exec();
}

/** Let's start patching ! */
void CScript::fairePatch()
{
  objAssistTrois.fichselect=fichselect;
  objAssistTrois.repbase=repbase;
  objAssistTrois.setOperation(0);
	objAssistTrois.exec();
}

/** A patch ? What is it ? */
void CScript::assistantUnPatch()
{
	if(objAssistUnPatch.exec())
	{
		fairePatch();
	}
	else
		assistantUn();
}

/** An installation ? What it is ? */
void CScript::assistantUnInstall()
{
	if(objAssistUnInstall.exec())
		assistantDeux();
	else
		assistantUn();
}

/** some useful tips for installation */
void CScript::assistantDeuxInstall()
{
	if(objAssistDeuxInstall.exec())
		faireInstallation();
	else
		assistantDeux();
}

/* A conversion ? What for ?*/
int CScript::assistantUnConversion()
{
	if(objAssistUnConversion.exec())
		return assistantDeuxConversion();
	else
		return assistantUn();
}

/* Select type of conversion */
int CScript::assistantDeuxConversion()
{
	objAssistDeuxConversion.setParametre(nomarchive);
	if(objAssistDeuxConversion.exec())
		return 2;
	else
		return assistantUnConversion();
}

/** return the conversion format */
int CScript::getTypeConversion()
{
	return objAssistDeuxConversion.type;
}

/** Return the directory where to store the
converted archive */
const char* CScript::getRepertoireConversion()
{
	return (const char*)objAssistDeuxConversion.repconv;
}

/* Return the directory or file for cutt/uncutt operations.
Needs to probe a .01 extension */
const char* CScript::getRepertoireCutt()
{
	return objAssistDeuxCutt.rep;
}

/** A split ? What for ? */
int CScript::assistantUnCutt()
{
	if(objAssistUnCutt.exec())
		return assistantDeuxCutt();
	else
		return assistantUn();
}

/** What kind of split ? */
int CScript::assistantDeuxCutt()
{
	if(objAssistDeuxCutt.exec())
		return 3;
	else
		return assistantUnCutt();
}