/***************************************************************************
                  optionsdialog.cpp  -  Options Dialog
                  ------------------------------------
    begin                : 08/01/99
    copyright            : (C) 1999 by Ryan Cumming
    email                : bodnar42@bodnar42.dhs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "optionsdialog.h"

optionsDialog::optionsDialog():QTabDialog(0,0,true){
	QWidget *generalTab = new QWidget(this, "generalTab");
	QWidget	*notificationTab = new QWidget(this, "notificationTab");
	QWidget	*iconTab = new QWidget(this, "iconTab");

	setCaption(i18n("KAPM Options"));
	setFixedSize(300, 300);
	setCancelButton();
	setApplyButton();

	addTab(generalTab, i18n("&General"));
	addTab(notificationTab, i18n("&Notification"));
	addTab( iconTab, i18n("Status &Icon") );

	// General tab	
	apmdRunning = new QCheckBox(i18n("I am running &apmd"), generalTab);
	apmdRunning->setGeometry(5, 10, 250, 20);
	
	updateInterval = new QSpinBox(10, 999, 10, generalTab);
	updateInterval->setGeometry(5, 45, 42, 20);
	
	updateIntervalLabel = new QLabel(updateInterval, i18n("Seconds between icon &updates"), generalTab);
	updateIntervalLabel->setGeometry(52, 45, 200, 20);

 // Notification tab
	lowNotification = new QCheckBox(i18n("Warn me when my battery is low"), notificationTab);
	lowNotification->setGeometry(5, 10, 250, 20);
	
	lowThresholdPercent = new QSpinBox(0, 75, 5, notificationTab);
	lowThresholdPercent->setGeometry(5, 40, 35, 20);
	
	lowThresholdPercentLabel = new QLabel(lowThresholdPercent, i18n("Percentage at which to warn me"), notificationTab);
	lowThresholdPercentLabel->setGeometry(45, 40, 200, 20);

	fullNotification = new QCheckBox(i18n("Notify me when my battery is full"), notificationTab);
	fullNotification->setGeometry(5, 75, 250, 20);
	
	fullThresholdPercent = new QSpinBox(75, 100, 5, notificationTab);
	fullThresholdPercent->setGeometry(5, 105, 42, 20);
	
	fullThresholdPercentLabel = new QLabel(fullThresholdPercent, i18n("Percentage at which to &notify me"), notificationTab);
	fullThresholdPercentLabel->setGeometry(52, 105, 200, 20);

	connect( this, SIGNAL(applyButtonPressed()), SLOT(saveConfig()) );
	connect( this, SIGNAL(cancelButtonPressed()), SLOT(reject()) );
	connect( lowNotification, SIGNAL(clicked()), SLOT(somethingChecked()) );
	connect( fullNotification, SIGNAL(clicked()), SLOT(somethingChecked()) );
	connect( this, SIGNAL(aboutToShow()), SLOT(loadConfig()) );

	// Icon tab

	// group box to hold the icons together
	QGroupBox* icons_groupbox = new QGroupBox(i18n("Icons:"), iconTab);
	icons_groupbox->move(5, 5);

	// layout to hold the icons inside the groupbox
	QVBoxLayout *icon_layout = new QVBoxLayout(icons_groupbox, 8);
	icon_layout->addSpacing(8);

	QGridLayout *icon_grid = new QGridLayout(2, 5);
	icon_layout->addLayout(icon_grid);

	icon_grid->setColStretch(0, 1);
	icon_grid->setColStretch(1, 1);
	icon_grid->setColStretch(2, 1);
	icon_grid->setColStretch(3, 1);

	QBoxLayout *crit_layout1 = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(crit_layout1, 0, 0);

	// "Critical" pixmap button
	QLabel* critical = new QLabel(i18n("Critical"), icons_groupbox);
	critical->setMinimumSize(critical->sizeHint());
	crit_layout1->addStretch(1);
	crit_layout1->addWidget(critical);
	crit_layout1->addStretch(1);

	QBoxLayout *low_layout1 = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(low_layout1, 0, 1);

	// "low" pixmap button
	QLabel* low_label = new QLabel(i18n("Low"), icons_groupbox);
	low_label->setMinimumSize(low_label->sizeHint());
	low_layout1->addStretch(1);
	low_layout1->addWidget(low_label);
	low_layout1->addStretch(1);

	QBoxLayout *high_layout1 = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(high_layout1, 0, 2);

	// "high" pixmap button
	QLabel* high_label = new QLabel(i18n("High"), icons_groupbox);
	high_label->setMinimumSize(high_label->sizeHint());
	high_layout1->addStretch(1);                                                                          	high_layout1->addWidget(high_label);
	high_layout1->addStretch(1);

	QBoxLayout *charging_layout1 = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(charging_layout1, 0, 3);

	// "Charging" pixmap button
	QLabel* charging_label = new QLabel(i18n("Charging"), icons_groupbox);
	charging_label->setMinimumSize(charging_label->sizeHint());
	charging_layout1->addStretch(1);
	charging_layout1->addWidget(charging_label);
	charging_layout1->addStretch(1);

	QBoxLayout *unknown_layout1 = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(unknown_layout1, 0, 4);

	// "unknown" pixmap button
	QLabel* unknown_label = new QLabel(i18n("Unknown"), icons_groupbox);
	unknown_label->setMinimumSize(unknown_label->sizeHint());
	unknown_layout1->addStretch(1);
	unknown_layout1->addWidget(unknown_label);
	unknown_layout1->addStretch(1);

	QBoxLayout *crit_layout = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(crit_layout, 1, 0);

	buttonCritical = new KIconLoaderButton(icons_groupbox);
	buttonCritical->setFixedSize(30, 30);
	crit_layout->addStretch(1);
	crit_layout->addWidget(buttonCritical);
	crit_layout->addStretch(1);

	QBoxLayout *low_layout = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(low_layout, 1, 1);

	buttonLow = new KIconLoaderButton(icons_groupbox);
	buttonLow->setFixedSize(30, 30);
	low_layout->addStretch(1);
	low_layout->addWidget(buttonLow);
	low_layout->addStretch(1);

	QBoxLayout *high_layout = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(high_layout, 1, 2);

	buttonHigh = new KIconLoaderButton(icons_groupbox);
	buttonHigh->setFixedSize(30, 30);
	high_layout->addStretch(1);
	high_layout->addWidget(buttonHigh);
	high_layout->addStretch(1);

	QBoxLayout *charging_layout = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(charging_layout, 1, 3);

	buttonCharging = new KIconLoaderButton(icons_groupbox);
	buttonCharging->setFixedSize(30, 30);
	charging_layout->addStretch(1);
	charging_layout->addWidget(buttonCharging);
	charging_layout->addStretch(1);

	QBoxLayout *unknown_layout = new QBoxLayout(QBoxLayout::LeftToRight);
	icon_grid->addLayout(unknown_layout, 1, 4);

	buttonUnknown = new KIconLoaderButton(icons_groupbox);
	buttonUnknown->setFixedSize(30, 30);
	unknown_layout->addStretch(1);
	unknown_layout->addWidget(buttonUnknown);
	unknown_layout->addStretch(1);

	icon_layout->activate();
}

optionsDialog::~optionsDialog(){
}

void optionsDialog::loadConfig() {
	apmdRunning->setChecked(config->apmdRunning);
	updateInterval->setValue(config->updateInterval / 1000);

	lowNotification->setChecked(config->lowNotification);
	lowThresholdPercent->setValue(config->lowThresholdPercent);	
	fullNotification->setChecked(config->fullNotification);
	fullThresholdPercent->setValue(config->fullThresholdPercent);

	buttonUnknown->setIcon(config->icons[0].filename);
	buttonCritical->setIcon(config->icons[1].filename);
	buttonLow->setIcon(config->icons[2].filename);
	buttonHigh->setIcon(config->icons[3].filename);
	buttonCharging->setIcon(config->icons[4].filename);

	somethingChecked();
}

void optionsDialog::saveConfig() {
	config->apmdRunning = apmdRunning->isChecked();
	config->updateInterval = updateInterval->value() * 1000;

	config->lowNotification = lowNotification->isChecked();
	config->lowThresholdPercent  = lowThresholdPercent->value();
	config->fullNotification = fullNotification->isChecked();
	config->fullThresholdPercent  = fullThresholdPercent->value();

	config->icons[0].filename = buttonUnknown->icon();	
	config->icons[1].filename = buttonCritical->icon();
	config->icons[2].filename = buttonLow->icon();
	config->icons[3].filename = buttonHigh->icon();
	config->icons[4].filename = buttonCharging->icon();

	for(char x = 0; x < 6;x++)
		config->icons[x].valid = false;
}

void optionsDialog::somethingChecked() {
	lowThresholdPercent->setEnabled( lowNotification->isChecked() );
	fullThresholdPercent->setEnabled( fullNotification->isChecked() );
}



























