/*  -*- C++ -*-
 * Qt widget for the addressbook example.
 * Declaration.
 *
 * the Configuration Database library
 * copyright:  (C) Mirko Sucker, 1998
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@hamburg.netsurf.de>
 *                          <mirko.sucker@unibw-hamburg.de>
 * requires:   C++-compiler, STL, string class, 
 *             NANA (only for debugging)
 * $Revision: 1.2 $
 */

#ifndef QADDRESSBOOK_WIDGET_H
#define QADDRESSBOOK_WIDGET_H

class QLineEdit;
class QFrame;
class QPushButton;
class QLabel;
class QComboBox;

#include "addressbook.h"
#include "businesscard.h"
#include "searchresults.h"
#include <drag.h>
#include <qprinter.h>

class KFM;

class AddressWidget 
  : public QWidget,
    public AddressBook
{
  Q_OBJECT
public:
  AddressWidget(QWidget* parent=0, 
		const char* name=0,
		bool readonly=false);
  ~AddressWidget();
  void currentChanged();
protected:
  // the child widgets:
  QComboBox* comboSelector;
  QFrame* frameSeparator1;
  QFrame* frameSeparator2;
  BusinessCard* card;
  QPushButton* buttonFirst; QPushButton* buttonPrevious;
  QPushButton* buttonNext; QPushButton* buttonLast;
  QPushButton* buttonAdd; QPushButton* buttonChange; 
  QPushButton* buttonRemove; QPushButton* buttonSearch;
  // the additional windows
  bool showSearchResults;
  SearchResults *searchResults; // zero if off
  // data elements
  KDNDDropZone* dropZone;
  KFM* kfm;
  string tmpFile;
  // methods
  void createConnections();
  void createTooltips();
  void updateSelector();
  void enableWidgets();
  bool edit(Entry&);
  // helper methods for printing:
  bool print(QPrinter&, 
	     const list<string>&,
	     const string& headline,
	     const string& footerLeft,
	     const string& footerRight);
  // they both return the height in points:
  int printHeadline(QPainter*, QRect, const string&);
  // page number, text
  int printFooter(QPainter*, QRect, int, 
		  string, string); 
  // CONSTS
  static const unsigned int ButtonSize;
  static const unsigned int Grid;
public slots:
  void initializeGeometry();
  void first();
  void previous();
  void next();
  void last();
  void select(int);
  void add(); // a new entry 
  void edit();
  void changed();
  void remove(); // current entry 
  void mail();
  void browse();
  void talk();
  void save();
  void print();
  void search();
  // called if data is dropped over this widget
  void dropAction(KDNDDropZone*);
  void searchResultsClose();
  void selectEntry(const char*); // the key
signals:
  void entrySelected(int current, int count);
  void sizeChanged();
  void enableMail(bool);
  void enableBrowse(bool);
  void setStatus(const char*);
};

#endif // QADDRESSBOOK_WIDGET_H
