/* -*- C++ -*-
 * This header tries to include all used STL header files 
 * and to resolve the usual problems concerning the order
 * of inclusion. Additionally it tries to resolve the 
 * differences that matter in kab between the HP STL shipped
 * with g++ 2.7.2 and the SGI STL shipped with later 
 * versions.
 * 
 * the Configuration Database library
 * copyright:  (C) Mirko Sucker, 1998
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@hamburg.netsurf.de>
 *                          <mirko.sucker@unibw-hamburg.de>
 * requires:   C++-compiler, STL, string class, NANA
 * $Revision: 1.1 $
 */

#ifndef MS_STL_HEADERS_H
#define MS_STL_HEADERS_H

#include <config.h>
#include <string>
#include <list>

/* The map-header is needed, but declares two global 
 * symbols that are also globally declared in Qt, "red"
 * and "black", in the HP version.
 * The fix has been delivered by Troll Tech, thanks.
 * 
 * The string class provided by the two STL versions have 
 * similar methods for deleting characters out of the 
 * strings, but one calls them "remove" (HP) and one calls 
 * them "erase" (SGI). kab uses the macro "ERASE" that is
 * set to the right value here. 
 * 
 * It is possible to define the STL version used by 
 * uncommenting one of the definitions below.
 */

// #define HAVE_HP_STL
// #define HAVE_SGI_STL

#if defined HAVE_HP_STL

#define red stl_red
#define black stl_black
#include <map>
#undef red
#undef black
#define ERASE remove

#else

/* hallo Burkhard: obwohl das hier die Sektion fuer libstdc++>=2.8
 * ist, habe ich hier probehalber die red und black-variable 
 * wegdefiniert. Laeufts jetzt?
 */
#define ERASE erase
#define red stl_red
#define black stl_black
#include <map>
#undef red
#undef black

#endif

#endif // MS_STL_HEADERS_H

