/**********************************************************************

	--- Qt Architect generated file ---

	File: SearchDialog.cpp
	Last generated: Wed Feb 25 17:48:48 1998

 *********************************************************************/

#include "SearchDialog.h"
#include <kapp.h>

#include "debug.h"

#undef Inherited
#define Inherited SearchDialogData

const char* SearchDialog::Keys[]= {
  "title",
  "firstname",
  "additionalName",
  "namePrefix",
  "name",
  "fn",
  "address",
  "town",
  "org",
  "role",
  "orgUnit",
  "orgSubUnit",
  "email",
  "email2",
  "email3",
  "telephone",
  "fax",
  "modem",
  "URL",
  "comment"
  /* , "deliveryLabel" */ };
  

SearchDialog::SearchDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
  setCaption(i18n("Search entries"));
  buttonSearch->setText(i18n("Search"));
  buttonCancel->setText(i18n("Cancel"));
  labelContains->setText(i18n("contains"));

  const char* Descriptions[]= {
    i18n("The title"),
    i18n("The first name"),
    i18n("The additional name"),
    i18n("The name prefix"),
    i18n("The name"),
    i18n("The formatted name"),
    i18n("The address"),
    i18n("The town"),
    i18n("The organization"),
    i18n("The role"),
    i18n("The org unit"),
    i18n("The org subunit"),
    i18n("The email address"),
    i18n("The second email address"),
    i18n("The third email address"),
    i18n("The telephone number"),
    i18n("The fax number"),
    i18n("The modem number"),
    i18n("The homepage URL"),
    i18n("The comment")
    /*, i18n("The delivery label") */ };
  const int Size
    =sizeof(Descriptions)/sizeof(Descriptions[0]);
  int count;
  // ---------
  for(count=0; count<Size; count++)
    {
      comboSelector->insertItem(Descriptions[count]);
    }
  connect(comboSelector, SIGNAL(activated(int)),
	  SLOT(keySelected(int)));
  connect(leWhat, SIGNAL(textChanged(const char*)),
	  SLOT(valueChanged(const char*)));
  keySelected(0);
  // ----------
  initializeGeometry();
}


SearchDialog::~SearchDialog()
{
}

void SearchDialog::keySelected(int index)
{
  REQUIRE(index>=0 
	  && (unsigned)index<(sizeof(Keys)
			      /sizeof(Keys[0])));
  L("SearchDialog::keySelected: key %s selected.\n",
    Keys[index]);
  key=Keys[index];
}

void SearchDialog::valueChanged(const char* value)
{
  L("SearchDialog::valueChanged: new value %s.\n",
    value);
  data=value;
}

void SearchDialog::initializeGeometry()
{
  const int Grid=5;
  int cx, cy=Grid;
  int x;
  // ------
  // we assume the entries in comboSelector are already inserted
  // and the text for labelContains to be set
  CHECK(comboSelector->count()>0);
  // find width:
  cx=Grid+comboSelector->sizeHint().width()
    +Grid+labelContains->sizeHint().width()
    +Grid+leWhat->fontMetrics().width("This is a long string.")
    +Grid;
  // now set geometries:
  x=Grid; 
  comboSelector->setGeometry(x, cy, 
			     comboSelector->sizeHint().width(),
			     comboSelector->sizeHint().height());
  x+=comboSelector->sizeHint().width()+Grid;
  labelContains->setGeometry(x, cy, 
			     labelContains->sizeHint().width(),
			     comboSelector->sizeHint().height()); // sic!
  x+=labelContains->sizeHint().width()+Grid;
  leWhat->setGeometry(x, cy,
		      leWhat->fontMetrics().width("This is a long string."),
		      comboSelector->sizeHint().height()); // sic!
  cy+=comboSelector->sizeHint().height()+Grid;
  // the horizontal line
  frameHorLine->setGeometry(Grid, cy,
			    cx-2*Grid,
			    2*Grid);
  cy+=3*Grid;
  // the buttons
  buttonSearch->sizeHint().width()>buttonCancel->sizeHint().width()
    ? x=buttonSearch->sizeHint().width()
    : x=buttonCancel->sizeHint().width();
  buttonSearch->setGeometry(Grid, 
			    cy,
			    x,
			    buttonSearch->sizeHint().height());
  buttonCancel->setGeometry(cx-Grid-buttonCancel->sizeHint().width(), 
			    cy,
			    x,
			    buttonCancel->sizeHint().height());
  cy+=buttonCancel->sizeHint().height()+Grid;
  // ------
  resize(cx, cy);
}

#include "SearchDialog.moc"
#include "SearchDialogData.moc"
