#ifndef KCOMMANDER2_H
#define KCOMMANDER2_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <ktoolbar.h>
#include <kprocess.h>
// include files for QT
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qdir.h>
// include files of project
#include "listview.h"
#include "dlgshow.h"
#include "dlgcopy2.h"
#include "dlgmove.h"
#include "dlgdel.h"
#include "dlgoptions.h"
#include "inputbox.h"
#include "aboutwindow.h"
#include "optionen.h"
#include "dlgpermissions.h"
#include "dlgfind.h"
#include "dlgsysinfo.h"
#include "dlgstartmenu.h"
#include "dlgsplit.h"

// forward declaration of the KCommander2 classes



class KCommander2App : public KTMainWindow
{
  Q_OBJECT


public:
  KCommander2App();
  ~KCommander2App();
	void 					saveOptions();
	void 					readOptions();
protected:

private slots:
	void 					resizeEvent(QResizeEvent *);
	void 					itemSelected();
	void 					itemDeSelected(const char *,const char *);
	void 					itemClicked(const char *,const char *);
	void 					itemDoubleClicked(const char *,const char *);
	void 					LVgotFocus();
	void 					LVlostFocus();
	void 					LVkeyPressed(const char *);
	void					menuActivated(int);
	void					menuPressed();
	void					buttonLeistePressed();
	void					driveActivated(const char *);
	void					LVcolums();
	void					commandBoxActivated();
	void					slotExamine();
	void					receivedStdout (KProcess *, char *, int);
	void					receivedStderr (KProcess *, char *, int);
	void					focusInEvent ( QFocusEvent * );
public slots:
	void					closeEvent ( QCloseEvent *);
private:
	KConfig				*config;
	KAccel				*key_accel;
//*************************************************
//	Class-Subroutinen
//*************************************************
	void 					initKeyAccel();
	void 					initMenuBar();
	void 					initToolBar();
	void 					initStatusBar();
	void 					init();
	void 					enableCommand(int);
	void 					disableCommand(int);
	void					writeRecursiveList(QFile *, const char *,int);
	void					convert(QString *);
	unsigned int 	getDirSize(QString,const unsigned int size=0);
	void					exec(const char *);
	void					mimeExec(const char *t);
	char 					*upDir(const char *);
	void 					insertParam(QString ,KShellProcess *);
public:
//*************************************************
//	Class-Variablen
//*************************************************
QLabel					*leftSelLabel;			// xx/xx Files selected
QLabel					*rightSelLabel;
QLabel					*commandLineLabel;	// path of the commandline
QComboBox				*commandBox,
								*leftDriveList,
								*rightDriveList;
QColorGroup 			*cg1,						// the two colorgroups of the
							*cg2;						// DirButtons
QPushButton			*buttonLeiste[7];

QPopupMenu			*popup0,
						*popup1,
						*popup2,
						*popup3,
						*popup4,
						*popup5,
						*popup6;
QPushButton			*leftDirButton,
						*rightDirButton;
QString					leftDirPath,
								rightDirPath;
listView				*linkerListView,
								*rechterListView,
								*listWithFocus;
bool						eingehangen;
};
 
#endif // KCOMMANDER2_H































