/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#ifndef KTHEMESOUNDCONFIG_H
#define KTHEMESOUNDCONFIG_H

#include <mediatool.h>
#include <kaudio.h>

#include <kapp.h>
#include <kcontrol.h>
#include <qlistbox.h>
#include <qpushbt.h>
#include <ktablistbox.h>
#include "theme.h"


class KThemeSoundConfig : public KConfigWidget{
	Q_OBJECT
public:
	KThemeSoundConfig(QWidget *parent=0, const char *name=0, Theme *t=NULL);
	~KThemeSoundConfig();
	void resizeEvent(QResizeEvent *);
	void writeSettings();
	void writeSettings(QString file);
	void loadSettings();

public slots:
	void applySettings();
	void selectScheme(int index);
	void loadScheme(QString name);
	void play();
	void stop();
	void themeChanged();
	void slot_saveScheme();
	void slot_deleteScheme();

private:
	KAudio		audio;

	QListBox 	*scheme_Listbox;
	QPushButton	*playbtn;
	QPushButton	*stopbtn;
	QPushButton	*saveScheme;
	QPushButton	*deleteScheme;
	KTabListBox	*preview;
	Theme		*theme;

	QString		path_scheme;
	QString		oldscheme;

	QString		stDesktop1;
	QString		stDesktop2;
	QString		stDesktop3;
	QString		stDesktop4;
	QString		stDesktop5;
	QString		stDesktop6;
	QString		stDesktop7;
	QString		stDesktop8;
	QString		stWindowActivate;
	QString		stWindowOpen;
	QString		stWindowClose;
	QString		stStartup;
	QString		stWindowShadeUp;
	QString		stWindowShadeDown;
	QString		stWindowIconify;
	QString		stWindowDeIconify;
	QString		stWindowMaximize;
	QString		stWindowUnMaximize;
	QString		stWindowSticky;
	QString		stWindowUnSticky;
	QString		stWindowTransNew;
	QString		stWindowTransDelete;
	QString		stLogout;
	QString		stLogoutMessage;
	QString		stWindowMoveStart;
	QString		stWindowMoveEnd;
	QString		stWindowResizeStart;
	QString		stWindowResizeEnd;
	QString		stEnable;
};

#endif


