#define ERG_MULT		1.0e4
#define ITN_MULT		1.0e3



******************** BEGIN MN_IAR.C ******************
double Tm_ang, Tm_sign ;

   fprintf( Log_fp, "A    = %-3s                    B    = %-3s                    C    = %-3s\n", A_type? "ON" : "OFF", B_type? "ON" : "OFF", C_type? "ON" : "OFF" ) ;
      fprintf( Log_fp, "A    = %-3s                    B    = %-3s                    C    = %-3s\n", A_type? "ON" : "OFF", B_type? "ON" : "OFF", C_type? "ON" : "OFF" ) ;

/*DEFINE DEFAULT PROJECTION FACTORS*/
   A_prj = B_prj = C_prj = 1.0 ;

/*SAVE TM ANGLE SIGN*/
   Tm_sign = (Tm_ang >= 0.0) ? 1.0 : -1.0 ;
   Tm_ang = fabs( Tm_ang ) ;


/*A TYPE (PROLATE LIMIT)*/
   if( !strcmp( Band_str, "A" ) )
      {

   /*ACTIVE STATUS INDICATOR*/
      A_type = 1 ;

   /*TM ORIENTATION PURELY A*/
      A_prj = 1.0 ;

   /*SET TRANSITION MOMENT ANGLE TO 0.0*/
      Tm_ang = 0.0 ;
      }


/*B TYPE (PROLATE LIMIT)*/
   else if( !strcmp( Band_str, "B" ) )
      {

   /*ACTIVE STATUS INDICATOR*/
      B_type = 1 ;

   /*TM ORIENTATION PURELY B*/
      B_prj = 1.0 ;

   /*SET TRANSITION MOMENT ANGLE TO 90.0*/
      Tm_ang = Tm_sign * 90.0 ;
      }


/*C TYPE (PROLATE LIMIT)*/
   else if( !strcmp( Band_str, "C" ) )
      {

   /*ACTIVE STATUS INDICATOR*/
      C_type = 1 ;

   /*TM ORIENTATION PURELY C*/
      C_prj = 1.0 ;

   /*SET TRANSITION MOMENT ANGLE TO 90.0*/
      Tm_ang = Tm_sign * 90.0 ;
      }


/*HYBRID BAND -> CHECK MAGNITUDE OF TM ORIENTATION -> RETURN WHEN GREATER THAN 90.0 DEGREES*/
   if( Tm_ang > 90.0 )
      {
      fprintf( Log_fp, "\nRDINPUTPARA -> TM ANGLE MUST BE BETWEEN -90 AND +90 DEGREES !\n" ) ;
      return( E_RT_UNK ) ;
      }




/*HYBRID BAND -> AB TYPE (PROLATE LIMIT) -> TM MEASURED WITH RESPECT TO A AXIS*/
   if( !strcmp( Band_str, "B/A" ) )
      {

   /*ACTIVE STATUS INDICATOR*/
      A_type = B_type = 1 ;


   /*TM BETWEEN 0 AND 45 DEGREES -> ALL B LINES SCALED DOWN*/
      if( Tm_ang <= 45.0 )
         {

      /*CALCULATE COMPONENTS ALONG A AND B -> B_PRJ (SIN TM) CARRIES SIGN*/
         A_prj = 1.0 ;
         B_prj = Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
         }

   /*TM BETWEEN 45 AND 90 DEGREES -> ALL A LINES SCALED DOWN*/
      else
         {

      /*CALCULATE COMPONENTS ALONG A AND B -> B_PRJ (SIN TM) CARRIES SIGN*/
         A_prj = tan( (90.0 - Tm_ang) * DEG_2_RAD ) ;
         B_prj = Tm_sign * 1.0 ;
         }
      }




/*HYBRID BAND -> AC TYPE (PROLATE LIMIT) -> TM MEASURED WITH RESPECT TO A AXIS*/
   else if( !strcmp( Band_str, "C/A" ) )
      {

   /*ACTIVE STATUS INDICATOR*/
      A_type = C_type = 1 ;


   /*TM BETWEEN 0 AND 45 DEGREES -> ALL C LINES SCALED DOWN*/
      if( Tm_ang <= 45.0 )
         {

      /*CALCULATE COMPONENTS ALONG A AND C -> C_PRJ (SIN TM) CARRIES SIGN*/
         A_prj = 1.0 ;
         C_prj = Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
         }

   /*TM BETWEEN 45 AND 90 DEGREES -> ALL A LINES SCALED DOWN*/
      else
         {

      /*CALCULATE COMPONENTS ALONG A AND C -> C_PRJ (SIN TM) CARRIES SIGN*/
         A_prj = tan( (90.0 - Tm_ang) * DEG_2_RAD ) ;
         C_prj = Tm_sign * 1.0 ;
         }
      }




/*HYBRID BAND -> BC TYPE (PROLATE LIMIT) -> TM MEASURED WITH RESPECT TO B AXIS*/
   else if( !strcmp( Band_str, "C/B" ) )
      {

   /*ACTIVE STATUS INDICATOR*/
      B_type = C_type = 1 ;


   /*TM BETWEEN 0 AND 45 DEGREES -> ALL C LINES SCALED DOWN*/
      if( Tm_ang <= 45.0 )
         {

      /*CALCULATE COMPONENTS ALONG B AND C -> C_PRJ (SIN TM) CARRIES SIGN*/
         B_prj = 1.0 ;
         C_prj = Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
         }

   /*TM BETWEEN 45 AND 90 DEGREES -> ALL B LINES SCALED DOWN*/
      else
         {

      /*CALCULATE COMPONENTS ALONG B AND C -> C_PRJ (SIN TM) CARRIES SIGN*/
         B_prj = tan( (90.0 - Tm_ang) * DEG_2_RAD ) ;
         C_prj = Tm_sign * 1.0 ;
         }
      }




/*CHECK BAND TYPE -> AT LEAST ONE STATUS FACTOR MUST BE SET*/
   if( !A_type && !B_type && !C_type )
      {
      fprintf( Log_fp, "\nIMPROPER BAND TYPE %s !\n", Band_str ) ;
      return( E_RT_UNK ) ;
      }





/*ROTATION ABOUT X(B) TENSOR ELEMENT <PYPZ + PZPY> ROTATED HAMILTONIAN -> REDEFINE BAND TYPE AND PROJECTIONS*/
   if( Phi_dc[ GND ] == -Chi_dc[ GND ] && fabs( Phi_dc[ GND ] ) > 89.9 * DEG_2_RAD &&
         The_dc[ GND ] == The_dc[ EXE ] &&
         Phi_dc[ GND ] == Phi_dc[ EXE ] && Chi_dc[ GND ] == Chi_dc[ EXE ] )
      {


   /*LOG ROTATION OF HAMILTONIAN*/
      fprintf( Log_fp, "\nBOTH HAMILTONIANS ROTATED ABOUT X BY %.3lf !\n", The_dc[ GND ] / DEG_2_RAD ) ;


   /*AC HYBRID BAND -> NO CORRECTION FOR PURE B TYPE TRANSITIONS*/
      if( A_type && C_type )
         {

      /*REDEFINE PROJECTION FACTORS -> TM BETWEEN 0 AND 45 DEGREES -> ALL C LINES SCALED DOWN*/
         if( Tm_ang <= 45.0 )
            {
            A_prj = cos( The_dc[ GND ] ) -
                    sin( The_dc[ GND ] ) * Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
            C_prj = sin( The_dc[ GND ] ) +
                    cos( The_dc[ GND ] ) * Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
            }

      /*REDEFINE PROJECTION FACTORS -> TM BETWEEN 45 AND 90 DEGREES -> ALL A LINES SCALED DOWN*/
         else
            {
            A_prj = cos( The_dc[ GND ] ) * Tm_sign * tan( (90.0 - Tm_ang) * DEG_2_RAD ) -
                    sin( The_dc[ GND ] ) ;
            C_prj = sin( The_dc[ GND ] ) * Tm_sign * tan( (90.0 - Tm_ang) * DEG_2_RAD ) +
                    cos( The_dc[ GND ] ) ;
            }
         }


   /*COMPONENT OF A TYPE -> NO CORRECTION FOR B TYPE PROJECTION*/
      else if( A_type )
         {

      /*TURN ON A AND C CONTRIBUTIONS*/
         A_type = C_type = 1 ;

      /*CORRECT PROJECTION FACTORS - BUT C IS ZERO*/
         A_prj *= cos( The_dc[ GND ] ) ;
         C_prj *= sin( The_dc[ GND ] ) ;
         }


   /*COMPONENT OF C TYPE -> NO CORRECTION FOR B TYPE PROJECTION*/
      else if( C_type )
         {

      /*TURN ON A AND C CONTRIBUTIONS*/
         A_type = C_type = 1 ;

      /*CORRECT PROJECTION FACTORS*/
         A_prj *= -sin( The_dc[ GND ] ) ;
         C_prj *= cos( The_dc[ GND ] ) ;
         }
      }






/*ROTATION ABOUT Z(A) TENSOR ELEMENT <PXPY + PXPY> ROTATED HAMILTONIAN -> REDEFINE BAND TYPE AND PROJECTIONS*/
   else if( fabs( Phi_dc[ GND ] ) > 0.0 && Phi_dc[ GND ] == Phi_dc[ EXE ] && !The_dc[ GND ] && !The_dc[ EXE ] )
      {


   /*LOG ROTATION OF HAMILTONIAN -> NO CORRECTION FOR PURE A TYPE TRANSITIONS*/
      fprintf( Log_fp, "\nBOTH HAMILTONIANS ROTATED ABOUT Z BY %.3lf !\n", Phi_dc[ GND ] / DEG_2_RAD ) ;


   /*BC HYBRID BAND -> NO CORRECTION FOR PURE A TYPE TRANSITIONS*/
      if( B_type && C_type )
         {

      /*REDEFINE PROJECTION FACTORS -> TM BETWEEN 0 AND 45 DEGREES -> ALL C LINES SCALED DOWN*/
         if( Tm_ang <= 45.0 )
            {
            B_prj = cos( Phi_dc[ GND ] ) -
                    sin( Phi_dc[ GND ] ) * Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
            C_prj = sin( Phi_dc[ GND ] ) +
                    cos( Phi_dc[ GND ] ) * Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
            }

      /*REDEFINE PROJECTION FACTORS -> TM BETWEEN 45 AND 90 DEGREES -> ALL B LINES SCALED DOWN*/
         else
            {
            B_prj = cos( Phi_dc[ GND ] ) * Tm_sign * tan( (90.0 - Tm_ang) * DEG_2_RAD ) -
                    sin( Phi_dc[ GND ] ) ;
            C_prj = sin( Phi_dc[ GND ] ) * Tm_sign * tan( (90.0 - Tm_ang) * DEG_2_RAD ) +
                    cos( Phi_dc[ GND ] ) ;
            }
         }


   /*COMPONENT OF B TYPE -> NO CORRECTION FOR A TYPE PROJECTION*/
      else if( B_type )
         {

      /*TURN ON B AND C CONTRIBUTIONS*/
         B_type = C_type = 1 ;

      /*CORRECT PROJECTION FACTORS*/
         B_prj *= cos( Phi_dc[ GND ] ) ;
         C_prj *= sin( Phi_dc[ GND ] ) ;
         }


   /*COMPONENT OF C TYPE -> NO CORRECTION FOR A TYPE PROJECTION*/
      else if( C_type )
         {

      /*TURN ON B AND C CONTRIBUTIONS*/
         B_type = C_type = 1 ;

      /*CORRECT PROJECTION FACTORS*/
         B_prj *= -sin( Phi_dc[ GND ] ) ;
         C_prj *= cos( Phi_dc[ GND ] ) ;
         }
      }






/*ROTATION ABOUT Y(C) TENSOR ELEMENT <PXPZ + PZPX> ROTATED HAMILTONIAN -> REDEFINE BAND TYPE AND PROJECTIONS*/
   else if( fabs( The_dc[ GND ] ) > 0.0 && The_dc[ GND ] == The_dc[ EXE ] && !Phi_dc[ GND ] && !Phi_dc[ EXE ] )
      {


   /*LOG ROTATION OF PRICIPLE FRAME*/
      fprintf( Log_fp, "\nBOTH HAMILTONIANS ROTATED ABOUT Y BY %.3lf !\n", The_dc[ GND ] / DEG_2_RAD ) ;


   /*AB HYBRID BAND -> NO CORRECTION FOR PURE C TYPE TRANSITIONS*/
      if( A_type && B_type )
         {

      /*REDEFINE PROJECTION FACTORS -> TM BETWEEN 0 AND 45 DEGREES -> ALL B LINES SCALED DOWN*/
         if( Tm_ang <= 45.0 )
            {
            A_prj = cos( The_dc[ GND ] ) -
                    sin( The_dc[ GND ] ) * Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
            B_prj = sin( The_dc[ GND ] ) +
                    cos( The_dc[ GND ] ) * Tm_sign * tan( Tm_ang * DEG_2_RAD ) ;
            }

      /*REDEFINE PROJECTION FACTORS -> TM BETWEEN 45 AND 90 DEGREES -> ALL A LINES SCALED DOWN*/
         else
            {
            A_prj = cos( The_dc[ GND ] ) * Tm_sign * tan( (90.0 - Tm_ang) * DEG_2_RAD ) -
                    sin( The_dc[ GND ] ) ;
            B_prj = sin( The_dc[ GND ] ) * Tm_sign * tan( (90.0 - Tm_ang) * DEG_2_RAD ) +
                    cos( The_dc[ GND ] ) ;
            }
         }


   /*COMPONENT OF A TYPE -> NO CORRECTION FOR C TYPE PROJECTION*/
      else if( A_type )
         {

      /*TURN ON A AND B CONTRIBUTIONS*/
         A_type = B_type = 1 ;

      /*CORRECT PROJECTION FACTORS*/
         A_prj *= cos( The_dc[ GND ] ) ;
         B_prj *= -sin( The_dc[ GND ] ) ;
         }


   /*COMPONENT OF B TYPE -> NO CORRECTION FOR B TYPE PROJECTION*/
      else if( B_type )
         {

      /*TURN ON A AND B CONTRIBUTIONS*/
         A_type = B_type = 1 ;

      /*CORRECT PROJECTION FACTORS*/
         A_prj *= -sin( The_dc[ GND ] ) ;
         B_prj *= cos( The_dc[ GND ] ) ;
         }
      }
   }


double UvMw_wt ;
   /ASSIGN FOR DEFAULT WEIGHTING FACTOR/
      UvMw_wt = 1.0 ;
   /ASSIGN FOR DEFAULT WEIGHTING FACTOR/
      UvMw_wt = 1.0 ;
   /CHECK FOR OLD INPUT FORMAT - FIRST CHARACTER IN THIS STRING SHOULD BE A CHAR OR A COMBINATION/
      if( isalpha( tstr[ 0 ] ) )
         {
   /CHECK FOR OLD INPUT FORMAT - READ NEXT STRING/
      fscanf( in_fp, "%s", tstr ) ;
      fscanf( in_fp, "%s", Mol_nm ) ;
      fgets( Mol_nm + strlen( Mol_nm ), CMT_LEN - strlen( Mol_nm ) - 1, in_fp ) ;

******************** END MN_IAR.C ******************


******************** BEGIN DHR_IAR.C ******************

/CALCULATE CORRECTION FACTORS FOR ROTATED HAMILTONIAN PRINCIPAL AXIS DERIVATIVES/
   double dv_sc, dv_s2, dv_c2 ;
   if( Tp_stat[ st ][ PXPZ ] )
      {
      dv_sc = sin( The_dc[ st ] ) * cos( The_dc[ st ] ) ;
      dv_c2 = cos( The_dc[ st ] ) * cos( The_dc[ st ] ) ;
      dv_s2 = sin( The_dc[ st ] ) * sin( The_dc[ st ] ) ;
      }

      /CALCULATE <PXPZ + PZPX> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND B DERIVATIVES/
         if( Tp_stat[ st ][ PXPZ ] )
            {

         /CALCULATE DER (DE/DX * DE/DZ + DE/DZ * DE/DX) -> LOOP THROUGH EIGENVECTOR/
            for( dv7_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv7_val += *(v_pt + col) * *(v_pt + col + 1) * pxpz_vec[ col ] ;

         /TRANSFORM DERIVATIVES INTO PRINCIPAL FRAME FOR LSF ANALYSIS - FACTOR 2 SYMMETRIC MATRIX/
            dv0_val = *(dvs_mat + row_ofs + A) ;
            dv12_val = *(dvs_mat + row_ofs + B) ;
            *(dvs_mat + row_ofs + A) = dv_c2 * dv0_val + dv_s2 * dv12_val - 2.0 * dv7_val * dv_sc ;
            *(dvs_mat + row_ofs + B) = dv_s2 * dv0_val + dv_c2 * dv12_val + 2.0 * dv7_val * dv_sc ;
            }


******************** END HLI_IAR.C ******************


******************** BEGIN HLI_IAR.C ******************

   fprintf( Log_fp, "\nBAND TYPE      = %s\n", Band_str ) ;
   fprintf( Log_fp, "TM ORIENTATION = %.3lf\n", Tm_sign * Tm_ang ) ;
   fprintf( Log_fp, "\nBAND TYPE      = %s\n", Band_str ) ;
   fprintf( Log_fp, "TM ORIENTATION = %.3lf\n", Tm_sign * Tm_ang ) ;

******************** END HLI_IAR.C ******************




****************** BEGIN DHI_IAR.C *****************
   for( col = 0; col < 3; col++ )
      t_mat[ col ][ 0 ] =
         dvr_mat[ col ][ 0 ] * par_mat[ 0 ][ 0 ] +
         dvr_mat[ col ][ 1 ] * par_mat[ 0 ][ 1 ] +
         dvr_mat[ col ][ 2 ] * par_mat[ 0 ][ 2 ] ;

      t_mat[ col ][ 1 ] =
         dvr_mat[ col ][ 0 ] * par_mat[ 1 ][ 0 ] +
         dvr_mat[ col ][ 1 ] * par_mat[ 1 ][ 1 ] +
         dvr_mat[ col ][ 2 ] * par_mat[ 1 ][ 2 ] ;

      t_mat[ col ][ 2 ] =
         dvr_mat[ col ][ 0 ] * par_mat[ 2 ][ 0 ] +
         dvr_mat[ col ][ 1 ] * par_mat[ 2 ][ 1 ] +
         dvr_mat[ col ][ 2 ] * par_mat[ 2 ][ 2 ] ;
      }


/*[Fg] * {[XYZ] * [Fg]-1} -> LOOP THROUGH DC ROWS AND T MATRIX COLUMNS*/
   for( col = 0; col < 3; col++ )
      {
      dvr_mat[ 0 ][ col ] =
         par_mat[ 0 ][ 0 ] * t_mat[ 0 ][ col ] +
         par_mat[ 0 ][ 1 ] * t_mat[ 1 ][ col ] +
         par_mat[ 0 ][ 2 ] * t_mat[ 2 ][ col ] ;

      dvr_mat[ 1 ][ col ] =
         par_mat[ 1 ][ 0 ] * t_mat[ 0 ][ col ] +
         par_mat[ 1 ][ 1 ] * t_mat[ 1 ][ col ] +
         par_mat[ 1 ][ 2 ] * t_mat[ 2 ][ col ] ;

      dvr_mat[ 2 ][ col ] =
         par_mat[ 2 ][ 0 ] * t_mat[ 0 ][ col ] +
         par_mat[ 2 ][ 1 ] * t_mat[ 1 ][ col ] +
         par_mat[ 2 ][ 2 ] * t_mat[ 2 ][ col ] ;
      }


/SIMILARITY TRANSFORMATION CHECK/
simtrans( bs_sz, j_qn, erg_ofs )
   long bs_sz, j_qn, erg_ofs ;
   {
   long k_qn, row_ct, col_ct ;
   double tmp1[ 100 ][ 100 ], tmp2[ 100 ][ 100 ], tmp3[ 100 ][ 100 ] ;



/INITIALIZE MATRICIES/
   for( col_ct = 0; col_ct < bs_sz; col_ct++ )
      for( row_ct = 0; row_ct < bs_sz; row_ct++ )
          *(*(tmp1 + col_ct) + row_ct) = *(*(tmp2 + col_ct) + row_ct) =
          *(*(tmp3 + col_ct) + row_ct) = 0.0 ;



/CALCULATE ON-DIAGONAL MATRIX ELEMENTS OF ORIGINAL HAMILTONIAN/
   for( k_qn = 0; k_qn <= j_qn; k_qn++ )
      *(*(tmp1 + j_qn - k_qn) + j_qn - k_qn) =
      *(*(tmp1 + j_qn + k_qn) + j_qn + k_qn) =
           F_val * j_qn * (j_qn + 1) + (G_val - F_val) * k_qn * k_qn ;

/CALCULATE OFF-DIAGONAL MATRIX ELEMENTS OF ORIGINAL HAMILTONIAN/
   for( k_qn = -j_qn; k_qn < j_qn - 1; k_qn++ )
      *(*(tmp1 + j_qn + k_qn) + j_qn + k_qn + 2) =
      *(*(tmp1 + j_qn + k_qn + 2) + j_qn + k_qn) =
            0.5 * H_val * sqrt( (double)(j_qn * (j_qn + 1) - k_qn * (k_qn + 1)) *
            (j_qn * (j_qn + 1) - (k_qn + 1) * (k_qn + 2)) ) ;



/MATRIX MULTIPLY -> A' = D~ * (A * D)/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp2 + row_ct) + col_ct) += *(*(tmp1 + row_ct) + k_qn) * *(hr_mat + k_qn * bs_sz + col_ct) ;


/MATRIX MULTIPLY -> A' = (D~ * (A * D))/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp3 + row_ct) + col_ct) += *(hr_mat + k_qn * bs_sz + row_ct) * *(*(tmp2 + k_qn) + col_ct) ;


   printf( "BS = %ld J_CT = %ld\n", bs_sz, j_qn ) ;
   fflush( stdout ) ;


/PRINT EIGENVALUES/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )        
      printf( "%12.2le", *(*(Erg_vec + st) + erg_ofs + row_ct) ) ;
   printf( "\n" ) ;


/PRINT MATRIX/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )        
      {
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         printf( "%12.2le", *(*(tmp3 + row_ct) + col_ct) ) ;

      printf( "\n" ) ;
      }
   }
*/
/*
simtrans( bs_sz )
   long bs_sz ;
   {
   long k_qn, row_ct, col_ct ;
   double tmp1[ 100 ][ 100 ], tmp2[ 100 ][ 100 ], tmp3[ 100 ][ 100 ] ;


   for( col_ct = 0; col_ct < bs_sz; col_ct++ )
      for( row_ct = 0; row_ct < bs_sz; row_ct++ )
          *(*(tmp1 + col_ct) + row_ct) = *(*(tmp1 + col_ct) + row_ct) =
          *(*(tmp2 + col_ct) + row_ct) = 0.0 ;


   for( col_ct = 0; col_ct < bs_sz; col_ct++ )
       *(*(tmp1 + col_ct) + col_ct) = *(Erg_vec + col_ct) ;


   for( row_ct = 0; row_ct <= bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp2 + row_ct) + col_ct) += *(*(tmp1 + row_ct) + k_qn) * *(hr_mat + col_ct * bs_sz + k_qn) ;

   for( row_ct = 0; row_ct < bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp3 + row_ct) + col_ct) += *(hr_mat + row_ct * bs_sz + k_qn) * *(*(tmp2 + k_qn) + col_ct) ;



   for( row_ct = 0; row_ct < bs_sz; row_ct++ )        
      {
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         printf( "%12.2le", *(*(tmp3 + row_ct) + col_ct) ) ;

      printf( "\n" ) ;
      }
   }
*/
/*
   /SKIP HEADER STUFF/
      lseek( bs_fd, (long)(BS_HEADER * sizeof( double )), 0 ) ;

   /SIMULARITY TRANSFORMATION/
      simtrans( bs_sz, j_qn, erg_ofs ) ;

      for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
         {
         for( cts = 0; cts < bs_sz; cts++ )
            printf( "%10.2le", *(hr_mat + k_qn * bs_sz + cts) ) ;

         printf( "\n" ) ;
         }
      printf( "\n" ) ;
*/
/*
double F_val, G_val, H_val ;

/DEFINE KAPPA -> PROLATE OR NEAR PROLATE TOP/
   if( (Kap[ st ] = (2 * B_rc[ st ] - A_rc[ st ] - C_rc[ st ]) / (A_rc[ st ] - C_rc[ st ])) <= -0.5 )
      {
      F_val = 0.5 * (Kap[ st ] - 1.0) ;
      G_val = 1.0 ;
      H_val = -0.5 * (Kap[ st ] + 1.0) ;
      }

/OBLATE OR NEAR OBLATE TOP/
   else if( Kap[ st ] >= 0.5 )
      {

      F_val = 0.5 * (Kap[ st ] + 1.0) ;
      G_val = -1.0 ;
      H_val = 0.5 * (Kap[ st ] - 1.0) ;
      }

/ASYMMETRY TOP/
   else
      {
      F_val = 0.0 ;
      G_val = Kap[ st ] ;
      H_val = 1.0 ;
      }

/PRINT KAPPA VALUE/
   printf( "KAPPA = %lf\n", Kap[ st ] ) ;

   /GENERATE DIAGONAL ELEMENTS OF HAMILTONIAN MATRIX (A = 1.0, B = KAPPA, C = -1.0)/
      for( k_qn = 0; k_qn <= j_qn; k_qn++ )
         {
         tmp = *(hr_mat + (j_qn + k_qn) * bs_sz + j_qn + k_qn) =
              F_val * j_qn * (j_qn + 1) + (G_val - F_val) * k_qn * k_qn ;
         *(hr_mat + (j_qn - k_qn) * bs_sz + j_qn - k_qn) = tmp ;
         }


   /GENERATE OFF-DIAGONAL ELEMENTS OF HAMILTONIAN MATRIX (A = 1.0, B = KAPPA, C = -1.0)/
      for( k_qn = 0; k_qn < 2 * j_qn - 1; k_qn++ )
         *(hr_mat + k_qn * bs_sz + k_qn + 2) =
         *(hr_mat + (k_qn + 2) * bs_sz + k_qn) =
               0.5 * H_val * sqrt( (double)(j_qn * (j_qn + 1) - (k_qn - j_qn) * (k_qn + 1 - j_qn)) *
               (j_qn * (j_qn + 1) - (k_qn + 1 - j_qn) * (k_qn + 2 - j_qn)) ) ;



   /GENERATE DIAGONAL ELEMENTS OF HAMILTONIAN MATRIX (A = 1.0, B = KAPPA, C = -1.0)/
      for( k_qn = 0; k_qn < 2 * j_qn; k_qn++ )
         {
         *(hr_mat + k_qn * bs_sz + k_qn + 1) =
         *(hr_mat + (k_qn + 1) * bs_sz + k_qn) =
               0.5 * A_val * (2.0 * k_qn + 1) *
               sqrt( (double)(j_qn * (j_qn + 1) - (k_qn - j_qn) * (k_qn + 1 - j_qn)) ) ;
         }



   /CALCULATE TOTAL ENERGY/
      for( k_qn = 0; k_qn < bs_sz; k_qn++ )
         *(*(Erg_vec + st) + erg_ofs + k_qn) =
               0.5 * (A_rc[ st ] + C_rc[ st ]) * j_qn * (j_qn + 1) +
               0.5 * (A_rc[ st ] - C_rc[ st ]) * *(*(Erg_vec + st) + erg_ofs + k_qn) ;

*/
/*
         if( j_qn <= Prt_ee[ 1 ] && j_qn >= Prt_ee[ 0 ] )
            {
            fprintf( Log_fp, "\nREAL = \n" ) ;
            for( row = 0; row < bs_sz; row++ )
               {
               for( col = 0; col < bs_sz; col++ )
                  fprintf( Log_fp, "%15.5lf", *(hr_mat + row * bs_sz + col) ) ;
               fprintf( Log_fp, "\n" ) ;
               }

            fprintf( Log_fp, "\n" ) ;
            }
         if( j_qn <= Prt_ee[ 1 ] && j_qn >= Prt_ee[ 0 ] )
            {
            fprintf( Log_fp, "IMAGINARY = \n" ) ;
            for( row = 0; row < bs_sz; row++ )
               {
               for( col = 0; col < bs_sz; col++ )
                  fprintf( Log_fp, "%15.5lf", *(hi_mat + row * bs_sz + col) ) ;
               fprintf( Log_fp, "\n" ) ;
               }

            fprintf( Log_fp, "\n" ) ;
            }

*/
/*
            printf( "\nPZ**2               PX**2               PY**2  J> %ld ROW> %ld\n", j_qn, row ) ;
            printf( "%-20.4lf", *(dvs_mat + row * no_dvs + 0) ) ;
            printf( "%-20.4lf%-.4lf\n", *(dvs_mat + row_ofs + 1), *(dvs_mat + row_ofs + 2) ) ;
            if( Rc_stat[ st ][ PZ ] )
               printf( "\nPZ> %.6lf\n", *(dvs_mat + row_ofs + 3) ) ;

      if( st == GND )
         for( row_ofs = 0, row = 0; row < bs_sz; row_ofs = ++row * no_dvs )
            for( col = 0; col < no_dvs; col++ )
               *(dvs_mat + row_ofs + col) *= -1.0 ;
*/
/*
CALCULATION OF PRINCIPAL AXIS DERIVATIVES IN ROTATED FRAME 
DOES THE SAME THING AS AXIS ROTATION - NOTE THE SIGN CHANGE ON THE PRODUCT MATRIX ELEMENTS
IN THE LOOP ABOVE
            *(dvs_mat + row_ofs + B) =
                  PAR_mat[ st ][ 0 ][ 0 ] * PAR_mat[ st ][ 0 ][ 0 ] * dvr_mat[ 0 ][ 0 ] +
                  PAR_mat[ st ][ 0 ][ 1 ] * PAR_mat[ st ][ 0 ][ 1 ] * dvr_mat[ 1 ][ 1 ] +
                  PAR_mat[ st ][ 0 ][ 2 ] * PAR_mat[ st ][ 0 ][ 2 ] * dvr_mat[ 2 ][ 2 ] +
            2.0 * PAR_mat[ st ][ 0 ][ 0 ] * PAR_mat[ st ][ 0 ][ 1 ] * dvr_mat[ 0 ][ 1 ] +
            2.0 * PAR_mat[ st ][ 0 ][ 0 ] * PAR_mat[ st ][ 0 ][ 2 ] * dvr_mat[ 0 ][ 2 ] +
            2.0 * PAR_mat[ st ][ 0 ][ 1 ] * PAR_mat[ st ][ 0 ][ 2 ] * dvr_mat[ 1 ][ 2 ] ;

            *(dvs_mat + row_ofs + C) =
                  PAR_mat[ st ][ 1 ][ 0 ] * PAR_mat[ st ][ 1 ][ 0 ] * dvr_mat[ 0 ][ 0 ] +
                  PAR_mat[ st ][ 1 ][ 1 ] * PAR_mat[ st ][ 1 ][ 1 ] * dvr_mat[ 1 ][ 1 ] +
                  PAR_mat[ st ][ 1 ][ 2 ] * PAR_mat[ st ][ 1 ][ 2 ] * dvr_mat[ 2 ][ 2 ] +
            2.0 * PAR_mat[ st ][ 1 ][ 0 ] * PAR_mat[ st ][ 1 ][ 1 ] * dvr_mat[ 0 ][ 1 ] +
            2.0 * PAR_mat[ st ][ 1 ][ 0 ] * PAR_mat[ st ][ 1 ][ 2 ] * dvr_mat[ 0 ][ 2 ] +
            2.0 * PAR_mat[ st ][ 1 ][ 1 ] * PAR_mat[ st ][ 1 ][ 2 ] * dvr_mat[ 1 ][ 2 ] ;

            *(dvs_mat + row_ofs + A) =
                  PAR_mat[ st ][ 2 ][ 0 ] * PAR_mat[ st ][ 2 ][ 0 ] * dvr_mat[ 0 ][ 0 ] +
                  PAR_mat[ st ][ 2 ][ 1 ] * PAR_mat[ st ][ 2 ][ 1 ] * dvr_mat[ 1 ][ 1 ] +
                  PAR_mat[ st ][ 2 ][ 2 ] * PAR_mat[ st ][ 2 ][ 2 ] * dvr_mat[ 2 ][ 2 ] +
            2.0 * PAR_mat[ st ][ 2 ][ 0 ] * PAR_mat[ st ][ 2 ][ 1 ] * dvr_mat[ 0 ][ 1 ] +
            2.0 * PAR_mat[ st ][ 2 ][ 0 ] * PAR_mat[ st ][ 2 ][ 2 ] * dvr_mat[ 0 ][ 2 ] +
            2.0 * PAR_mat[ st ][ 2 ][ 1 ] * PAR_mat[ st ][ 2 ][ 2 ] * dvr_mat[ 1 ][ 2 ] ;

PRINT MATRIX
   if( j_qn == 3 )
      {
      printf( "AFTER DV_MAT %ld\n", j_qn ) ;
      for( row_ct = 0; row_ct < 3; row_ct++ )        
         {
         for( col_ct = 0; col_ct < 3; col_ct++ )
            printf( "%12.2le", *(*(derr_mat + row_ct) + col_ct) ) ;
          printf( "\n" ) ;
         }
      }
*/
/*
      /CALCULATE <PXPY + PYPX> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND B DERIVATIVES/
         else if( Tp_stat[ st ][ PXPY ] )
            {

         /CALCULATE DER (DE/DX*DE/DY + DE/DY*DE/DX) -> LOOP THROUGH EIGENVECTOR/
            for( dv6_val = 0.0, col = 0; col < bs_sz - 2; col++ )
               dv6_val -= (*(vr_pt + col) * *(vi_pt + col + 2) -
                           *(vi_pt + col) * *(vr_pt + col + 2)) * pp2pm2_vec[ col ] ;
            dv0_val = *(dvs_mat + row_ofs + B) ;
            dv12_val = *(dvs_mat + row_ofs + C) ;
            *(dvs_mat + row_ofs + B) = dv_c2 * dv0_val + dv_s2 * dv12_val + 2.0 * dv6_val * dv_sc ;
            *(dvs_mat + row_ofs + C) = dv_s2 * dv0_val + dv_c2 * dv12_val - 2.0 * dv6_val * dv_sc ;
            }


      /CALCULATE <PXPZ + PZPX> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND B DERIVATIVES/
         else if( Tp_stat[ st ][ PXPZ ] )
            {

         /CALCULATE DER (DE/DX*DE/DZ + DE/DZ*DE/DX) -> LOOP THROUGH EIGENVECTOR/
            for( dv7_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv7_val += (*(vr_pt + col) * *(vr_pt + col + 1) +
                           *(vi_pt + col) * *(vi_pt + col + 1)) * pxypz_vec[ col ] ;

         /TRANSFORM DERIVATIVES INTO PRINCIPAL FRAME FOR LSF ANALYSIS/
            dv0_val = *(dvs_mat + row_ofs + A) ;
            dv12_val = *(dvs_mat + row_ofs + B) ;
            *(dvs_mat + row_ofs + A) = dv_c2 * dv0_val + dv_s2 * dv12_val + 2.0 * dv7_val * dv_sc ;
            *(dvs_mat + row_ofs + B) = dv_s2 * dv0_val + dv_c2 * dv12_val - 2.0 * dv7_val * dv_sc ;
            }


      /CALCULATE <PYPZ + PZPY> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND C DERIVATIVES/
         else if( Tp_stat[ st ][ PYPZ ] )
            {

         /CALCULATE DER (DE/DY*DE/DZ + DE/DZ*DE/DY) -> LOOP THROUGH EIGENVECTOR/
            for( dv8_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv8_val -= (*(vr_pt + col) * *(vi_pt + col + 1) -
                           *(vi_pt + col) * *(vr_pt + col + 1)) * pxypz_vec[ col ] ;

         /TRANSFORM DERIVATIVES INTO PRINCIPAL FRAME FOR LSF ANALYSIS/
            dv0_val = *(dvs_mat + row_ofs + A) ;
            dv12_val = *(dvs_mat + row_ofs + C) ;
            *(dvs_mat + row_ofs + A) = dv_c2 * dv0_val + dv_s2 * dv12_val + 2.0 * dv8_val * dv_sc ;
            *(dvs_mat + row_ofs + C) = dv_s2 * dv0_val + dv_c2 * dv12_val - 2.0 * dv8_val * dv_sc ;
            }


   double dv_sc, dv_s2, dv_c2 ;

/CALCULATE CORRECTION FACTORS FOR ROTATED HAMILTONIAN PRINCIPAL AXIS DERIVATIVES/
   if( Tp_stat[ st ][ PXPY ] )
      {
      dv_sc = sin( Phi_dc[ st ] ) * cos( Phi_dc[ st ] ) ;
      dv_c2 = cos( Phi_dc[ st ] ) * cos( Phi_dc[ st ] ) ;
      dv_s2 = sin( Phi_dc[ st ] ) * sin( Phi_dc[ st ] ) ;
      }

/CALCULATE CORRECTION FACTORS FOR ROTATED HAMILTONIAN PRINCIPAL AXIS DERIVATIVES/
   if( Tp_stat[ st ][ PXPZ ] )
      {
      dv_sc = sin( The_dc[ st ] ) * cos( The_dc[ st ] ) ;
      dv_c2 = cos( The_dc[ st ] ) * cos( The_dc[ st ] ) ;
      dv_s2 = sin( The_dc[ st ] ) * sin( The_dc[ st ] ) ;
      }

/CALCULATE CORRECTION FACTORS FOR ROTATED HAMILTONIAN PRINCIPAL AXIS DERIVATIVES/
   if( Tp_stat[ st ][ PYPZ ] )
      {
      dv_sc = sin( The_dc[ st ] ) * cos( The_dc[ st ] ) ;
      dv_c2 = cos( The_dc[ st ] ) * cos( The_dc[ st ] ) ;
      dv_s2 = sin( The_dc[ st ] ) * sin( The_dc[ st ] ) ;
      }

****************** END DHI_IAR.C *****************



******************** BEGIN ITT_IAR.C ******************
   double t_mat[ 3 ], tm_mat[ 3 ][ 3 ] ;

/*ANGLE DESCRIPTION OF TRANSITION MOMENT ACCORDING TO THETA AND CHI*/

   /*CALCULATE ROTATION MATRIX FOR ROTATION OF TRANSITION MOMENT ACCORDING TO PHI, THETA AND CHI*/
      EulerGenMat( -1, tm_mat, tm_ori[ PHI ], tm_ori[ THE ], tm_ori[ CHI ] ) ;


   /*DEFINE TM AS VECTOR ALONG A AXIS OF GIVEN MAGNITUDE*/
      tm_prj[ A ] = tm_mag ;

   /*ROTATE TRANSITION MOMENT ACCORDING TO PHI, THETA AND CHI -> mu[BCA] = [gF]-1 * [A]*/
      t_mat[ B ] =
         tm_mat[ 0 ][ 0 ] * tm_prj[ B ] +
         tm_mat[ 1 ][ 0 ] * tm_prj[ C ] +
         tm_mat[ 2 ][ 0 ] * tm_prj[ A ] ;

      t_mat[ C ] =
         tm_mat[ 0 ][ 1 ] * tm_prj[ B ] +
         tm_mat[ 1 ][ 1 ] * tm_prj[ C ] +
         tm_mat[ 2 ][ 1 ] * tm_prj[ A ] ;

      t_mat[ A ] =
         tm_mat[ 0 ][ 2 ] * tm_prj[ B ] +
         tm_mat[ 1 ][ 2 ] * tm_prj[ C ] +
         tm_mat[ 2 ][ 2 ] * tm_prj[ A ] ;


      tm_prj[ B ] = t_mat[ B ] ;
      tm_prj[ C ] = t_mat[ C ] ;
      tm_prj[ A ] = t_mat[ A ] ;


double It_mat[ ST_NO ][ 3 ][ 3 ] ;

short HamParaCalc( int st, double it_mat[ 3 ][ 3 ], double hp_mat[ 3 ][ 3 ] ) ;

   ixyz_mat[ 0 ][ 0 ] = ERG_2_MKS / hp_mat[ 0 ][ 0 ] ;
   ixyz_mat[ 1 ][ 1 ] = ERG_2_MKS / hp_mat[ 1 ][ 1 ] ;
   ixyz_mat[ 2 ][ 2 ] = ERG_2_MKS / hp_mat[ 2 ][ 2 ] ;
   ixyz_mat[ 0 ][ 1 ] = ixyz_mat[ 1 ][ 0 ] = 0.0 ;
   ixyz_mat[ 0 ][ 2 ] = ixyz_mat[ 2 ][ 0 ] = 0.0 ;
   ixyz_mat[ 1 ][ 2 ] = ixyz_mat[ 2 ][ 1 ] = 0.0 ;


/CALCULATE NEW INERTIAL TENSOR SUBJECT TO EULER ANGLES PHI, THETA OR CHI/
   EulerRot( st, Hp_mat[ st ], It_mat[ st ] ) ;

/CALCULATE NEW HAMILTONIAN PARAMETERS SUBJECT TO ANY TRANSFORMATION/
   HamParaCalc( st, It_mat[ st ], Hp_mat[ st ] ) ;




/*[U]-1 * [I] * [U] WHERE U = [Fg] -> EULER ANGLE UNITARY TRANSFORMATION OF INERTIAL TENSOR MATRIX*/
short EulerRot( int st, double hp_mat[ 3 ][ 3 ], double fxyz_mat[ 3 ][ 3 ] )
   {
   long row, col ;
   double ixyz_mat[ 3 ][ 3 ], t_mat[ 3 ][ 3 ] ;


/*CONVERT ROTATIONAL CONSTANTS (MHZ) TO INERTIAL PARAMETERS (AMU * ANGSTROMS**2)*/
   ixyz_mat[ 0 ][ 0 ] = hp_mat[ 0 ][ 0 ] ;
   ixyz_mat[ 1 ][ 1 ] = hp_mat[ 1 ][ 1 ] ;
   ixyz_mat[ 2 ][ 2 ] = hp_mat[ 2 ][ 2 ] ;
   ixyz_mat[ 0 ][ 1 ] = ixyz_mat[ 1 ][ 0 ] = 0.0 ;
   ixyz_mat[ 0 ][ 2 ] = ixyz_mat[ 2 ][ 0 ] = 0.0 ;
   ixyz_mat[ 1 ][ 2 ] = ixyz_mat[ 2 ][ 1 ] = 0.0 ;


/*LOG INERTIAL TENSOR MATRIX*/
   if( Err == 1 )
      {
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "INITIAL %s STATE INERTIAL TENSOR (AMU * ANGSTROMS**2) !\n", St_str[ st ] ) ;
      fprintf( Log_fp, "Ix                                Iy                                Iz\n" ) ;
      for( row = 0; row < 3; row++ )
         fprintf( Log_fp, "%-34.6lf%-34.6lf%.6lf\n", ixyz_mat[ row ][ 0 ], ixyz_mat[ row ][ 1 ], ixyz_mat[ row ][ 2 ] ) ;
      }


/*[XYZ] * [Fg] -> LOOP THROUGH XYZ ROWS AND DC COLUMNS*/
   for( row = 0; row < 3; row++ )
      {

   /*SUM OVER PRODUCT ELEMENTS OF ROW ELEMENT OF XYZ MATRIX AND COLUMN ELEMENT OF DC MATRIX*/
      t_mat[ row ][ 0 ] =
         ixyz_mat[ row ][ 0 ] * PAR_mat[ st ][ 0 ][ 0 ] +
         ixyz_mat[ row ][ 1 ] * PAR_mat[ st ][ 1 ][ 0 ] +
         ixyz_mat[ row ][ 2 ] * PAR_mat[ st ][ 2 ][ 0 ] ;


   /*SUM OVER PRODUCT ELEMENTS OF ROW ELEMENT OF XYZ MATRIX AND COLUMN ELEMENT OF DC MATRIX*/
      t_mat[ row ][ 1 ] =
         ixyz_mat[ row ][ 0 ] * PAR_mat[ st ][ 0 ][ 1 ] +
         ixyz_mat[ row ][ 1 ] * PAR_mat[ st ][ 1 ][ 1 ] +
         ixyz_mat[ row ][ 2 ] * PAR_mat[ st ][ 2 ][ 1 ] ;


   /*SUM OVER PRODUCT ELEMENTS OF ROW ELEMENT OF XYZ MATRIX AND COLUMN ELEMENT OF DC MATRIX*/
      t_mat[ row ][ 2 ] =
         ixyz_mat[ row ][ 0 ] * PAR_mat[ st ][ 0 ][ 2 ] +
         ixyz_mat[ row ][ 1 ] * PAR_mat[ st ][ 1 ][ 2 ] +
         ixyz_mat[ row ][ 2 ] * PAR_mat[ st ][ 2 ][ 2 ] ;
      }


/*[Fg]-1 * {[XYZ] * [Fg]} -> LOOP THROUGH DC ROWS AND T MATRIX COLUMNS*/
   for( col = 0; col < 3; col++ )
      {

   /*SUM OVER PRODUCT ELEMENTS OF ROW ELEMENT OF DIRECTIONAL COSINE MATRIX AND COLUMN OF XYZ MATRIX*/
      fxyz_mat[ 0 ][ col ] = hp_mat[ 0 ][ col ] =
         PAR_mat[ st ][ 0 ][ 0 ] * t_mat[ 0 ][ col ] +
         PAR_mat[ st ][ 1 ][ 0 ] * t_mat[ 1 ][ col ] +
         PAR_mat[ st ][ 2 ][ 0 ] * t_mat[ 2 ][ col ] ;


   /*SUM OVER PRODUCT ELEMENTS OF ROW ELEMENT OF DIRECTIONAL COSINE MATRIX AND COLUMN OF XYZ MATRIX*/
      fxyz_mat[ 1 ][ col ] = hp_mat[ 1 ][ col ] =
         PAR_mat[ st ][ 0 ][ 1 ] * t_mat[ 0 ][ col ] +
         PAR_mat[ st ][ 1 ][ 1 ] * t_mat[ 1 ][ col ] +
         PAR_mat[ st ][ 2 ][ 1 ] * t_mat[ 2 ][ col ] ;


   /*SUM OVER PRODUCT ELEMENTS OF ROW ELEMENT OF DIRECTIONAL COSINE MATRIX AND COLUMN OF XYZ MATRIX*/
      fxyz_mat[ 2 ][ col ] = hp_mat[ 2 ][ col ] =
         PAR_mat[ st ][ 0 ][ 2 ] * t_mat[ 0 ][ col ] +
         PAR_mat[ st ][ 1 ][ 2 ] * t_mat[ 1 ][ col ] +
         PAR_mat[ st ][ 2 ][ 2 ] * t_mat[ 2 ][ col ] ;
      }


/*LOG TRANSFORMED INERTIAL TENSOR*/
   if( Err == 1 )
      {
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "TRANSFORMED %s STATE INERTIAL TENSOR (AMU * ANGSTROMS**2) !\n", St_str[ st ] ) ;
      fprintf( Log_fp, "Ix                                Iy                                Iz\n" ) ;
      for( row = 0; row < 3; row++ )
         fprintf( Log_fp, "%-34.6lf%-34.6lf%.6lf\n", fxyz_mat[ row ][ 0 ], fxyz_mat[ row ][ 1 ], fxyz_mat[ row ][ 2 ] ) ;
      }


/*LOG HAMILTONIAN PARAMETER MATRIX*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "                 %s STATE HAMILTONIAN PARAMETER MATRIX !\n", St_str[ st ] ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "B(X)                              C(Y)                              A(Z)\n" ) ;
   for( row = 0; row < 3; row++ )
      fprintf( Log_fp, "%-34.6lf%-34.6lf%.6lf\n", hp_mat[ row ][ 0 ], hp_mat[ row ][ 1 ], hp_mat[ row ][ 2 ] ) ;


/*RETURN SUCCESS*/
   return( 1 ) ;
   }




/CALCULATE NEW HAMILTONIAN PARAMETERS SUBJECT TO ANY TRANSFORMATION -> P.6 WILSON, DECIUS & CROSS/
short HamParaCalc( int st, double it_mat[ 3 ][ 3 ], double hp_mat[ 3 ][ 3 ] )
   {
   int row ;
   double inert_det ;



/DEFINE INERTIAL TENSOR DETERMINANT/
   inert_det = 
         it_mat[ 0 ][ 0 ] * (it_mat[ 1 ][ 1 ] * it_mat[ 2 ][ 2 ] -
                             it_mat[ 1 ][ 2 ] * it_mat[ 2 ][ 1 ]) -
         it_mat[ 0 ][ 1 ] * (it_mat[ 1 ][ 0 ] * it_mat[ 2 ][ 2 ] +
                             it_mat[ 1 ][ 2 ] * it_mat[ 2 ][ 0 ]) -
         it_mat[ 0 ][ 2 ] * (it_mat[ 1 ][ 0 ] * it_mat[ 2 ][ 1 ] +
                             it_mat[ 1 ][ 1 ] * it_mat[ 2 ][ 0 ]) ;


/REDEFINE HAMILTONIAN PARAMETERS -> DIAGONAL ELEMENTS/
   hp_mat[ 0 ][ 0 ] = ERG_2_MKS *
         (it_mat[ 1 ][ 1 ] * it_mat[ 2 ][ 2 ] -
          it_mat[ 1 ][ 2 ] * it_mat[ 1 ][ 2 ]) / inert_det ;

   hp_mat[ 1 ][ 1 ] = ERG_2_MKS *
         (it_mat[ 0 ][ 0 ] * it_mat[ 2 ][ 2 ] -
          it_mat[ 0 ][ 2 ] * it_mat[ 0 ][ 2 ]) / inert_det ;

   hp_mat[ 2 ][ 2 ] = ERG_2_MKS *
         (it_mat[ 0 ][ 0 ] * it_mat[ 1 ][ 1 ] -
          it_mat[ 0 ][ 1 ] * it_mat[ 0 ][ 1 ]) / inert_det ;



/REDEFINE HAMILTONIAN PARAMETERS -> OFF DIAGONAL ELEMENTS -> SYMMETRIC MATRIX/
   hp_mat[ 0 ][ 1 ] = hp_mat[ 1 ][ 0 ] = ERG_2_MKS *
         (it_mat[ 0 ][ 1 ] * it_mat[ 2 ][ 2 ] +
          it_mat[ 1 ][ 2 ] * it_mat[ 0 ][ 2 ]) / inert_det ;

   hp_mat[ 0 ][ 2 ] = hp_mat[ 2 ][ 0 ] = ERG_2_MKS *
         (it_mat[ 0 ][ 1 ] * it_mat[ 1 ][ 2 ] +
          it_mat[ 1 ][ 1 ] * it_mat[ 0 ][ 2 ]) / inert_det ;

   hp_mat[ 1 ][ 2 ] = hp_mat[ 2 ][ 1 ] = ERG_2_MKS *
         (it_mat[ 0 ][ 0 ] * it_mat[ 1 ][ 2 ] +
          it_mat[ 0 ][ 1 ] * it_mat[ 0 ][ 2 ]) / inert_det ;



/LOG HAMILTONIAN PARAMETER MATRIX/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "                 %s STATE HAMILTONIAN PARAMETER MATRIX !\n", St_str[ st ] ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "B(X)                              C(Y)                              A(Z)\n" ) ;
   for( row = 0; row < 3; row++ )
      fprintf( Log_fp, "%-34.6lf%-34.6lf%.6lf\n", hp_mat[ row ][ 0 ], hp_mat[ row ][ 1 ], hp_mat[ row ][ 2 ] ) ;


/RETURN SUCCESS/
   return( 1 ) ;
   }
*/
******************** END ITT_IAR.C ******************


