// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// iar interface
// IAR is an calculation engine to generate and fit rovibronic spectra.
//
// Copyright (C) 1998 Dave Plusquellic
// Copyright (C) 1998,1999 Jochen Kpper



#ifndef KROT_IAR_H
#define KROT_IAR_H


struct iarParameter
{
};



struct iarAssignment
{
};



struct iarLines
{
};



/**
 * Interface function to IAR.
 *
 * @param param Start parameter for calculation.
 * @param asn   Assignments to use for fits. For simulations this might be set to zero.
 * @param lines Output of simulated lines. Terminated by an entry with all members beeing zero.
 * @return Final parameters of calculation.
 */
extern struct iarParameter *iar( const iarParameter param, const iarAssignment *asn, iarLines *lines );



#endif
