/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DHI_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"


int ee_fd, qn_fd, dv_fd ;
extern int evr_fd, evi_fd ;

double *hr_mat, *hi_mat, *vr_mat, *vi_mat, *od_vec, *od1_vec, *tau_mat ;
double *dvs_mat, *pp2pm2_vec, *pxpy_vec, *pxypz_vec ;


short IHamSoln( int st ) ;
short IHamInit( int st ) ;
void PrntEigErg( long j_qn, short *ka_ary, short *kc_ary, double *erg_ary ) ;
void PrntEigVec( long j_qn, short *ka_ary, short *kc_ary, double *vec_mat ) ;
int htridi_( long *nm, long *n, double *ar, double *ai, double *d__, double *e, double *e2, double *tau) ;
int imtql2_( long *nm, long *n, double *d__, double *e, double *z__, long *ierr ) ;
int htribk_( long *nm, long *n, double *ar, double *ai, double *tau, long *m, double *zr, double *zi ) ;
short DerBackRotation( int st, double *dvp_mat, double dc_mat[ 3 ][ 3 ], double dvr_mat[ 3 ][ 3 ] ) ;

short SAlloc1Dim( short **ptpt, long sz ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;








/*GENERATE HAMILTONIAN MATRIX*/
short IHamSoln( int st )
   {
   long ierr ;
   long cnt, cts, row, col, row_ofs, dv_ct ;
   long j_qn, k_qn, jj1_val ;
   long kac_ct, erg_ofs, bs_sz, no_dvs ;
   double ak_hp, aj_hp, akpkm_hp ;
   double *vr_pt, *vi_pt, erg ;
   double dv_val, dv0_val, dv12_val, dv3_val, dv4_val, dv5_val ;
   double dv6_val, dv7_val, dv8_val, dv10_val, dv13_val, dv14_val ;
   double dvr_mat[ 3 ][ 3 ] ;


/*OPEN NEEDED FILES AND ALLOCATE NEEDED SPACE FOR ALL MATRICIES AND VECTORS*/
   if( IHamInit( (int)st ) == -1 )
      return( -1 ) ;


/*MICROWAVE - FOR EXCITED STATE MAKE SAME AS GND STATE ARRAYS*/
   if( st && !Rc[ EXE ][ ORI ] )
      {

   /*COPY EIGEN ENERGIES AND QUANTUM #'S*/
      for( cnt = 0; cnt < J_max * (J_max + 2) + 1 ; cnt++ )        
         {
         *(*(Erg_vec + 1) + cnt) = *(*(Erg_vec + 0) + cnt) ;
         Ka_ary[ 1 ][ cnt ] = Ka_ary[ 0 ][ cnt ] ;
         Kc_ary[ 1 ][ cnt ] = Kc_ary[ 0 ][ cnt ] ;
         }

   /*RETURN SUCCESS*/
      return( 1 ) ;
      }



/*DEFINE KAPPA -> PROLATE OR NEAR PROLATE TOP*/
   if( Rc[ st ][ A ] != Rc[ st ][ C ] )
      Kap[ st ] = (2 * Rc[ st ][ B ] - Rc[ st ][ A ] - Rc[ st ][ C ]) /
           (Rc[ st ][ A ] - Rc[ st ][ C ]) ;

/*PRINT KAPPA VALUE*/
   fprintf( Log_fp, "%s STATE KAPPA = %f (IMAGINARY)\n\n", St_str[ st ], Kap[ st ] ) ;





/*DEFINE SYMMETRIC ROTOR PARAMETERS -> REP IR*/
   aj_hp = (Rc[ st ][ B ] + Rc[ st ][ C ]) / 2.0 ;
   ak_hp = Rc[ st ][ A ] - (Rc[ st ][ B ] + Rc[ st ][ C ]) / 2.0 ;

/*DEFINE ASYMMETRIC ROTOR PARAMETER*/
   akpkm_hp = (Rc[ st ][ B ] - Rc[ st ][ C ]) / 2.0 ;

/*DEREFERENCE TOTAL # OF DERVATIVES FOR STATE*/
   no_dvs = St_nodv[ st ] ;



/*CALCULATE MATRIX ELEMENTS AND DIAGONALIZE FOR EVERY J BETWEEN 0 AND J_MAX*/
   for( kac_ct = 0, bs_sz = 1, erg_ofs = 0, j_qn = 0; j_qn <= J_max; bs_sz = 2 * ++j_qn + 1 )
      { 


   /*DEFINE J * (J + 1) VALUE*/
      jj1_val = j_qn * (j_qn + 1) ;


   /*INITIALIZE REAL AND IMAGINARY PARTS OF HAMILTONIAN MATRIX*/
      for( row_ofs = 0, row = 0; row < bs_sz; row_ofs = ++row * bs_sz )        
         {
         for( col = 0; col < bs_sz; col++ )
            {
            *(hr_mat + row_ofs + col) = *(hi_mat + row_ofs + col) = 0.0 ;
            *(vr_mat + row_ofs + col) = 0.0 ;
            }
         *(vr_mat + row_ofs + row) = 1.0 ;
         }





   /*GENERATE DIAGONAL ELEMENTS IN ASYMMETRIC ROTOR HAMILTONIAN MATRIX*/
      for( k_qn = 0, row = 0; row <= j_qn; row++, k_qn++ )
         *(hr_mat + (j_qn + row) * bs_sz + j_qn + row) =
         *(hr_mat + (j_qn - row) * bs_sz + j_qn - row) = 
               aj_hp * jj1_val +
               ak_hp * k_qn * k_qn ;


   /*GENERATE OFF-DIAGONAL ELEMENTS IN ASYMMETRIC ROTOR HAMILTONIAN MATRIX*/
      for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
         *(hr_mat + row * bs_sz + row + 2) =
         *(hr_mat + (row + 2) * bs_sz + row) =
               akpkm_hp * (pp2pm2_vec[ row ] = 0.5 * sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                     (jj1_val - (k_qn + 1) * (k_qn + 2)) )) ;





   /*GENERATE <PX> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PX ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 1; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row + 1) =
            *(hr_mat + (row + 1) * bs_sz + row) += Rc[ st ][ PX ] *
                  (pxpy_vec[ row ] = 0.5 * sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) )) ;


   /*GENERATE <PY> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PY ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 1; row++, k_qn++ )
            *(hi_mat + row * bs_sz + row + 1) =
            -(*(hi_mat + (row + 1) * bs_sz + row) += Rc[ st ][ PY ] *
                  (pxpy_vec[ row ] = 0.5 * sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) ))) ;


   /*GENERATE <PZ> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PZ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row) +=
                  Rc[ st ][ PZ ] * k_qn ;


   /*GENERATE <PXPY + PYPX> PERTURBATION OR PRODUCT TENSOR MATRIX ELEMENTS*/
      if( Rc_stat[ st ][ PXPY ] || Tp_stat[ st ][ PXPY ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
            *(hi_mat + row * bs_sz + row + 2) =
            -(*(hi_mat + (row + 2) * bs_sz + row) +=
                  Rc[ st ][ PXPY ] * pp2pm2_vec[ row ]) ;


   /*GENERATE <PXPZ + PZPX> PERTURBATION OR PRODUCT TENSOR MATRIX ELEMENTS*/
      if( Rc_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PXPZ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 1; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row + 1) =
            (*(hr_mat + (row + 1) * bs_sz + row) +=
                  Rc[ st ][ PXPZ ] * (pxypz_vec[ row ] = 0.5 * (2.0 * k_qn + 1) *
                  sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) ))) ;


   /*GENERATE <PYPZ + PZPY> PERTURBATION OR PRODUCT TENSOR MATRIX ELEMENTS*/
      if( Rc_stat[ st ][ PYPZ ] || Tp_stat[ st ][ PYPZ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 1; row++, k_qn++ )
            *(hi_mat + row * bs_sz + row + 1) =
            -(*(hi_mat + (row + 1) * bs_sz + row) +=
                  Rc[ st ][ PYPZ ] * (pxypz_vec[ row ] = 0.5 * (2.0 * k_qn + 1) *
                  sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) ))) ;




   /*GENERATE <DK> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ DK ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row) +=
                  -Rc[ st ][ DK ] * k_qn * k_qn * k_qn * k_qn ;

   /*GENERATE <DJK> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ DJK ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row) +=
                  -Rc[ st ][ DJK ] * jj1_val * k_qn * k_qn ;


   /*GENERATE <DJ> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ DJ ] )
         for( row = 0; row < bs_sz; row++ )
            *(hr_mat + row * bs_sz + row) +=
                  -Rc[ st ][ DJ ] * jj1_val * jj1_val ;

   /*GENERATE <dK> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX - A REDUCTION*/
      if( Rc_stat[ st ][ dK ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row + 2) =
            (*(hr_mat + (row + 2) * bs_sz + row) +=
                  -Rc[ st ][ dK ] * 0.5 * (k_qn * k_qn + (k_qn + 2) * (k_qn + 2)) *
                        sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                        (jj1_val - (k_qn + 1) * (k_qn + 2)) )) ;

   /*GENERATE <dJ> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX - A REDUCTION*/
      if( Rc_stat[ st ][ dJ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row + 2) =
            (*(hr_mat + (row + 2) * bs_sz + row) +=
                  -Rc[ st ][ dJ ] * 1.0 * jj1_val *
                        sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                                      (jj1_val - (k_qn + 1) * (k_qn + 2)) )) ;





   /*GENERATE <PZ**3> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PZ3 ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(hr_mat + row * bs_sz + row) +=
                  Rc[ st ][ PZ3 ] * k_qn * k_qn * k_qn ;





   /*PRINT HAMILTONIAN MATRIX*/
      if( Err == 1 )
         {
         printf( "\nHAM REAL MATRIX J = %ld\n", j_qn ) ;
         for( row = 0; row < bs_sz; row++ )
            {
            for( col = 0; col < bs_sz; col++ )
               printf( "%15.5f", *(hr_mat + row * bs_sz + col) ) ;
            printf( "\n" ) ;
            }

         printf( "\nHAM IMAG MATRIX J = %ld\n", j_qn ) ;
         for( row = 0; row < bs_sz; row++ )
            {
            for( col = 0; col < bs_sz; col++ )
               printf( "%15.5f", *(hi_mat + row * bs_sz + col) ) ;
            printf( "\n" ) ;
            }
         printf( "\n" ) ;
         }






   /*COMPLEX DIAGONALIZATION FOR HERMATIAN MATRICIES*/
      htridi_( &bs_sz, &bs_sz, hr_mat, hi_mat, *(Erg_vec+ st) + erg_ofs, od_vec, od1_vec, tau_mat ) ;

   /*DIAGONALIZATION PROCEDURE FOR TRIDIAGONAL MATRICIES -> RETURNS EIGEN VALUES AND VECTORS*/
      imtql2_( &bs_sz, &bs_sz, *(Erg_vec + st) + erg_ofs, od_vec, vr_mat, &ierr ) ;

   /*DIAGONALIZATION PROCEDURE FOR TRIDIAGONAL MATRICIES -> RETURNS EIGEN VALUES AND VECTORS*/
      htribk_( &bs_sz, &bs_sz, hr_mat, hi_mat, tau_mat, &bs_sz, vr_mat, vi_mat ) ;




   /*WRITE REAL PART OF EIGENVECTORS IN ROW FORM*/
      write( evr_fd, (char *)vr_mat, bs_sz * bs_sz * sizeof( double ) ) ;

   /*WRITE IMAGINARY PART OF EIGENVECTORS IN ROW FORM*/
      write( evi_fd, (char *)vi_mat, bs_sz * bs_sz * sizeof( double ) ) ;





   /*CALCULATE DERIVATIVES FOR LEAST SQUARES PHASE OR FOR DERIVATIVE APPROXIMATION*/
      for( dv_ct = 0, row_ofs = 0, row = 0; row < bs_sz; row_ofs = ++row * no_dvs, dv_ct = 0 )
         {

      /*REASSIGN ADDRESS TO TEMPORARY POINTER*/
         vr_pt = vr_mat + row * bs_sz ;
         vi_pt = vi_mat + row * bs_sz ;

      /*CALCULATE DERIVATIVES (DE/DPZ) AND (DE/DPZ**2) -> LOOP THROUGH EIGENVECTOR*/
         for( dv0_val = dv5_val = dv10_val = dv13_val = 0.0, k_qn = -j_qn, col = 0; col < bs_sz; col++, k_qn++ )
            {
            dv_val = (*(vr_pt + col) * *(vr_pt + col) + *(vi_pt + col) * *(vi_pt + col)) * k_qn ;
            dv0_val += dv_val * k_qn ;
            dv5_val += dv_val ;
            dv10_val += dv_val * k_qn * k_qn ;
            dv13_val += dv_val * k_qn * k_qn * k_qn ;
            }


      /*CALCULATE DER (DE/DX**2) AND (DE/DY**2) -> LOOP THROUGH EIGENVECTOR*/
         for( dv12_val = 0.0, col = 0; col < bs_sz - 2; col++ )
            dv12_val += (*(vr_pt + col) * *(vr_pt + col + 2) +
                         *(vi_pt + col) * *(vi_pt + col + 2)) * pp2pm2_vec[ col ] ;


      /*ASSIGN PZ**2 DERIVATIVE*/
         *(dvs_mat + row_ofs + dv_ct++) = dv0_val ;

      /*ASSIGN B AND C DERIVATIVES*/
         *(dvs_mat + row_ofs + dv_ct++) = 0.5 * (jj1_val - dv0_val) + dv12_val ;
         *(dvs_mat + row_ofs + dv_ct++) = 0.5 * (jj1_val - dv0_val) - dv12_val ;





      /*CALCULATE AND ASSIGN <PX> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PX ] )
            {

         /*CALCULATE DER (DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dv3_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv3_val += (*(vr_pt + col) * *(vr_pt + col + 1) +
                           *(vi_pt + col) * *(vi_pt + col + 1)) * pxpy_vec[ col ] ;

            *(dvs_mat + row_ofs + dv_ct++) = 2.0 * dv3_val ;
            }


      /*CALCULATE AND ASSIGN <PY> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PY ] )
            {

         /*CALCULATE DER (DE/DY) -> LOOP THROUGH EIGENVECTOR*/
            for( dv4_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv4_val += (*(vr_pt + col) * *(vi_pt + col + 1) -
                           *(vi_pt + col) * *(vr_pt + col + 1)) * pxpy_vec[ col ] ;

            *(dvs_mat + row_ofs + dv_ct++) = -2.0 * dv4_val ;
            }


      /*ASSIGN PZ DERIVATIVE*/
         if( Rc_stat[ st ][ PZ ] )
            *(dvs_mat + row_ofs + dv_ct++) = dv5_val ;


      /*CALCULATE AND ASSIGN <PXPY + PYPX> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PXPY ] )
            {

         /*CALCULATE DER (DE/DX*DE/DY + DE/DY*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dv6_val = 0.0, col = 0; col < bs_sz - 2; col++ )
               dv6_val -= (*(vr_pt + col) * *(vi_pt + col + 2) -
                           *(vi_pt + col) * *(vr_pt + col + 2)) * pp2pm2_vec[ col ] ;

         /*ASSIGN <PXPY + PYPX> PERTURBATION OR TENSOR PRODUCT DERIVATIVE*/
            *(dvs_mat + row_ofs + dv_ct++) = 2.0 * dv6_val ;
            }



      /*CALCULATE AND ASSIGN <PXPZ + PZPX> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PXPZ ] )
            {

         /*CALCULATE DER (DE/DX*DE/DZ + DE/DZ*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dv7_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv7_val += (*(vr_pt + col) * *(vr_pt + col + 1) +
                           *(vi_pt + col) * *(vi_pt + col + 1)) * pxypz_vec[ col ] ;

         /*ASSIGN <PXPZ + PZPX> PERTURBATION OR TENSOR PRODUCT DERIVATIVE*/
            *(dvs_mat + row_ofs + dv_ct++) = 2.0 * dv7_val ;
            }



      /*CALCULATE AND ASSIGN <PYPZ + PZPY> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PYPZ ] )
            {

         /*CALCULATE DER (DE/DY*DE/DZ + DE/DZ*DE/DY) -> LOOP THROUGH EIGENVECTOR*/
            for( dv8_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv8_val -= (*(vr_pt + col) * *(vi_pt + col + 1) -
                           *(vi_pt + col) * *(vr_pt + col + 1)) * pxypz_vec[ col ] ;

         /*ASSIGN <PYPZ + PZPY> PERTURBATION OR TENSOR PRODUCT DERIVATIVE*/
            *(dvs_mat + row_ofs + dv_ct++) = 2.0 * dv8_val ;
            }




      /*DETERMINE PRINCIPAL AXIS DERIVATIVES FOR GENERAL AXIS ROTATION OUT OF ALL PRINCIPAL AXES - F TO g*/
         if( Tp_stat[ st ][ PXPY ] && Tp_stat[ st ][ PXPZ ] && Tp_stat[ st ][ PYPZ ] )
            {

         /*CALCULATE DER (BC) (DE/DX*DE/DY + DE/DY*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dvr_mat[ 0 ][ 1 ] = 0.0, col = 0; col < bs_sz - 2; col++ )
               dvr_mat[ 0 ][ 1 ] -= (*(vr_pt + col) * *(vi_pt + col + 2) -
                           *(vi_pt + col) * *(vr_pt + col + 2)) * pp2pm2_vec[ col ] ;
            dvr_mat[ 1 ][ 0 ] = dvr_mat[ 0 ][ 1 ] ;

         /*CALCULATE DER (AB) (DE/DX*DE/DZ + DE/DZ*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dvr_mat[ 0 ][ 2 ] = 0.0, col = 0; col < bs_sz - 1; col++ )
               dvr_mat[ 0 ][ 2 ] += (*(vr_pt + col) * *(vr_pt + col + 1) +
                           *(vi_pt + col) * *(vi_pt + col + 1)) * pxypz_vec[ col ] ;
            dvr_mat[ 2 ][ 0 ] = dvr_mat[ 0 ][ 2 ] ;

         /*CALCULATE DER (AC) (DE/DY*DE/DZ + DE/DZ*DE/DY) -> LOOP THROUGH EIGENVECTOR*/
            for( dvr_mat[ 1 ][ 2 ] = 0.0, col = 0; col < bs_sz - 1; col++ )
               dvr_mat[ 1 ][ 2 ] -= (*(vr_pt + col) * *(vi_pt + col + 1) -
                           *(vi_pt + col) * *(vr_pt + col + 1)) * pxypz_vec[ col ] ;
            dvr_mat[ 2 ][ 1 ] = dvr_mat[ 1 ][ 2 ] ;


         /*ROTATE DERIVATIVE MATRIX BACK INTO PRINCIPAL AXIS FRAME*/
            DerBackRotation( st, dvs_mat + row_ofs, HamRot_mat[ st ], dvr_mat ) ;
            }




      /*DETERMINE PRINCIPAL AXIS DERIVATIVES FOR IN AXIS ROTATION OUT OF TWO PRINCIPAL AXES - F TO g*/
         else if( Tp_stat[ st ][ PXPY ] || Tp_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PYPZ ] )
            {

         /*CALCULATE <PXPY + PYPX> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND B DERIVATIVES TO PRINCIPAL VALUES*/
            if( Tp_stat[ st ][ PXPY ] )
               {

            /*CALCULATE DER (BC) (DE/DX*DE/DY + DE/DY*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
               for( dvr_mat[ 0 ][ 1 ] = 0.0, col = 0; col < bs_sz - 2; col++ )
                  dvr_mat[ 0 ][ 1 ] -= (*(vr_pt + col) * *(vi_pt + col + 2) -
                           *(vi_pt + col) * *(vr_pt + col + 2)) * pp2pm2_vec[ col ] ;
               dvr_mat[ 1 ][ 0 ] = dvr_mat[ 0 ][ 1 ] ;
               dvr_mat[ 2 ][ 0 ] = dvr_mat[ 0 ][ 2 ] = 0.0 ;
               dvr_mat[ 2 ][ 1 ] = dvr_mat[ 1 ][ 2 ] = 0.0 ;
               }

         /*CALCULATE <PXPZ + PZPX> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND B DERIVATIVES*/
            else if( Tp_stat[ st ][ PXPZ ] )
               {

            /*CALCULATE DER (AB) (DE/DX*DE/DZ + DE/DZ*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
               for( dvr_mat[ 0 ][ 2 ] = 0.0, col = 0; col < bs_sz - 1; col++ )
                  dvr_mat[ 0 ][ 2 ] += (*(vr_pt + col) * *(vr_pt + col + 1) +
                              *(vi_pt + col) * *(vi_pt + col + 1)) * pxypz_vec[ col ] ;
               dvr_mat[ 1 ][ 0 ] = dvr_mat[ 0 ][ 1 ] = 0.0 ;
               dvr_mat[ 2 ][ 0 ] = dvr_mat[ 0 ][ 2 ] ;
               dvr_mat[ 2 ][ 1 ] = dvr_mat[ 1 ][ 2 ] = 0.0 ;
               }

         /*CALCULATE <PYPZ + PZPY> TENSOR PRODUCT DERIVATIVE AND CORRECT A AND C DERIVATIVES*/
            else if( Tp_stat[ st ][ PYPZ ] )
               {

            /*CALCULATE DER (AC) (DE/DY*DE/DZ + DE/DZ*DE/DY) -> LOOP THROUGH EIGENVECTOR*/
               for( dvr_mat[ 1 ][ 2 ] = 0.0, col = 0; col < bs_sz - 1; col++ )
                  dvr_mat[ 1 ][ 2 ] -= (*(vr_pt + col) * *(vi_pt + col + 1) -
                              *(vi_pt + col) * *(vr_pt + col + 1)) * pxypz_vec[ col ] ;
               dvr_mat[ 1 ][ 0 ] = dvr_mat[ 0 ][ 1 ] = 0.0 ;
               dvr_mat[ 2 ][ 0 ] = dvr_mat[ 0 ][ 2 ] = 0.0 ;
               dvr_mat[ 2 ][ 1 ] = dvr_mat[ 1 ][ 2 ] ;
               }


         /*ROTATE DERIVATIVE MATRIX BACK INTO PRINCIPAL AXIS FRAME*/
            DerBackRotation( st, dvs_mat + row_ofs, HamRot_mat[ st ], dvr_mat ) ;
            }



      /*ASSIGN DK DERIVATIVE*/
         if( Rc_stat[ st ][ DK ] )
            *(dvs_mat + row_ofs + dv_ct++) = -dv13_val ;

      /*ASSIGN DJK DERIVATIVE*/
         if( Rc_stat[ st ][ DJK ] )
            *(dvs_mat + row_ofs + dv_ct++) = -jj1_val * dv0_val ;

      /*ASSIGN DJ DERIVATIVE*/
         if( Rc_stat[ st ][ DJ ] )
            *(dvs_mat + row_ofs + dv_ct++) = -(double)jj1_val * jj1_val ;


      /*ASSIGN dK DERIVATIVE - COULD SAVE FROM MATRIX ELEMENT GENERATION*/
         if( Rc_stat[ st ][ dK ] )
            {

         /*LOOP THROUGH EIGENVECTOR*/
            for( dv14_val = 0.0, k_qn = -j_qn, col = 0; col < bs_sz - 2; col++, k_qn++ )
               dv14_val += (*(vr_pt + col) * *(vr_pt + col + 2) + 
                            *(vi_pt + col) * *(vi_pt + col + 2)) *
                     (k_qn * k_qn + (k_qn + 2) * (k_qn + 2)) *
                     sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                                   (jj1_val - (k_qn + 1) * (k_qn + 2)) ) ;

         /*ASSIGN <dK> DISTORTION PERTURBATION -> 2 FROM SYMMETRIC MATRIX*/
            *(dvs_mat + row_ofs + dv_ct++) = -1.0 * dv14_val ;
            }

      /*ASSIGN dJ DERIVATIVE - COULD SAVE FROM MATRIX ELEMENT GENERATION*/
         if( Rc_stat[ st ][ dJ ] )
            {

         /*LOOP THROUGH EIGENVECTOR*/
            for( dv14_val = 0.0, k_qn = -j_qn, col = 0; col < bs_sz - 2; col++, k_qn++ )
               dv14_val += (*(vr_pt + col) * *(vr_pt + col + 2) +
                            *(vi_pt + col) * *(vi_pt + col + 2)) *
                     jj1_val *
                     sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                                   (jj1_val - (k_qn + 1) * (k_qn + 2)) ) ;

         /*ASSIGN <dJ> DISTORTION PERTURBATION -> 2 FROM SYMMETRIC MATRIX*/
            *(dvs_mat + row_ofs + dv_ct++) = -2.0 * dv14_val ;
            }




      /*ASSIGN PZ**3 DERIVATIVE*/
         if( Rc_stat[ st ][ PZ3 ] )
            *(dvs_mat + row_ofs + dv_ct++) = dv10_val ;




      /*ERROR ANALYSIS*/
         if( Err == 1 )
            {

         /*PRINT DERIVATIVES FOR A, B, AND C*/
            printf( "\nJ> %ld R> %ld ", j_qn, row ) ;
            printf( "PZ**2> %f   ", *(dvs_mat + row_ofs + A) ) ;
            printf( "PX**2> %f   PY**2> %f   ", *(dvs_mat + row_ofs + B), *(dvs_mat + row_ofs + C) ) ;

         /*PRINT DERIVATIVES FOR REMAINING ACTIVE PARAMETERS*/
            if( Rc_stat[ st ][ PX ] )
               printf( "PX> %f   ", 2.0 * dv3_val ) ;

            if( Rc_stat[ st ][ PY ] )
               printf( "PY> %f   ", -2.0 * dv4_val ) ;

            if( Rc_stat[ st ][ PZ ] )
               printf( "PZ> %f   ", dv5_val ) ;

            if( Rc_stat[ st ][ PXPY ] )
               printf( "PXPY> %f   ", -2.0 * dv6_val ) ;

            if( Rc_stat[ st ][ PXPZ ] )
               printf( "PXPZ> %f   ", 2.0 * dv7_val  ) ;

            if( Rc_stat[ st ][ PYPZ ] )
               printf( "PYPZ> %f   ", -2.0 * dv8_val ) ;

            if( Rc_stat[ st ][ DJ ] )
               printf( "DJ> %f   ", (double)-j_qn * (j_qn + 1) * j_qn * (j_qn + 1) ) ;

            if( Rc_stat[ st ][ PZ3 ] )
               printf( "PZ3> %f", dv10_val ) ;
            printf( "\n" ) ;


         /*CALCULATE ENERGY BASED ON DERIVATIVES*/
            erg = Tp[ st ][ A ] * *(dvs_mat + row_ofs + A) + Tp[ st ][ B ] * *(dvs_mat + row_ofs + B) +
                  Tp[ st ][ C ] * *(dvs_mat + row_ofs + C) ;

         /*LOOP THROUGH REMAINING DERIVATIVES FOR ACTIVE PARAMETERS*/
            for( cnt = 2, cts = 3; cts < no_dvs; cts++ )
               {
               while( !Rc_stat[ st ][ ++cnt ] )
                  ;
               erg += Rc[ st ][ cnt ] * *(dvs_mat + row_ofs + cts) ;
               }

         /*PRINT ENERGY FROM DIAGONALIZATION AND FROM DERIVATIVE CALCULATION*/
            printf( "HAM ERG = %f DER ERG = %f\n", *(*(Erg_vec + st) + erg_ofs + row), erg ) ;
            fflush( stdout ) ;
            }
         }



   /*MICROWAVE - WRITE DERIVATIVES OUT TO FILE*/
   /*SIGN CHANGE FOR LOWER STATE DONE IN TRANSITION CALCULATION - PHASE III*/
      write( dv_fd, (char *)dvs_mat, bs_sz * no_dvs * sizeof( double ) ) ;



   /*CALCULATE QUANTUM #'S*/
      for( k_qn = 0; k_qn < bs_sz; kac_ct++ )
         {

      /*CALCULATE KC*/
         *(*(Kc_ary + st) + kac_ct) = j_qn - (k_qn++ >> 1) ;

      /*CALCULATE KA*/
         *(*(Ka_ary + st) + kac_ct) = k_qn >> 1 ;
         }


   /*PRINT EIGEN ENERGIES FOR SELECTED LEVELS*/
      if( j_qn <= Prt_ee[ 1 ] && j_qn >= Prt_ee[ 0 ] )
         PrntEigErg( j_qn, Ka_ary[ st ] + erg_ofs, Kc_ary[ st ] + erg_ofs, Erg_vec[ st ] + erg_ofs ) ;


   /*LOG IMAGINARY AND REAL EIGEN VECTORS*/
      if( j_qn <= Prt_ev[ 1 ] && j_qn >= Prt_ev[ 0 ] )
         {
         PrntEigVec( j_qn, Ka_ary[ st ] + erg_ofs, Kc_ary[ st ] + erg_ofs, vr_mat ) ;
         PrntEigVec( j_qn, Ka_ary[ st ] + erg_ofs, Kc_ary[ st ] + erg_ofs, vi_mat ) ;
         }


   /*INCREAMENT ENERGY OFFSET FACTOR*/
      erg_ofs += bs_sz ;
      }



/*CALCULATE TOTAL SIZE OF VECTORS*/
   bs_sz = (J_max * (J_max + 2) + 1) ;

/*WRITE ALL EIGENVALUES OUT TO FILE*/
   write( ee_fd, (char *)*(Erg_vec + st), bs_sz * sizeof( double ) ) ;

/*WRITE ALL QUANTUM #'S OUT TO FILE*/
   write( qn_fd, (char *)*(Ka_ary + st), bs_sz * sizeof( short ) ) ;
   write( qn_fd, (char *)*(Kc_ary + st), bs_sz * sizeof( short ) ) ;




/*FREE SPACE*/
   DFree1Dim( &hr_mat ) ;
   DFree1Dim( &hi_mat ) ;
   DFree1Dim( &vr_mat ) ;
   DFree1Dim( &vi_mat ) ;
   DFree1Dim( &tau_mat ) ;
   DFree1Dim( &od_vec ) ;
   DFree1Dim( &od1_vec ) ;
   DFree1Dim( &dvs_mat ) ;
   DFree1Dim( &pp2pm2_vec ) ;

   if( Rc_stat[ st ][ PX ] || Rc_stat[ st ][ PY ] )
      DFree1Dim( &pxpy_vec ) ;

   if( Rc_stat[ st ][ PXPZ ] || Rc_stat[ st ][ PYPZ ] ||
         Tp_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PYPZ ] )
      DFree1Dim( &pxypz_vec ) ;


/*CLOSE FILES*/
   close( ee_fd ) ;
   close( qn_fd ) ;
   close( dv_fd ) ;
   close( evr_fd ) ;
   close( evi_fd ) ;



/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*OPEN NEEDED FILES AND ALLOCATE NEEDED SPACE FOR ALL MATRICIES AND VECTORS*/
short IHamInit( int st )
   {
   char end_flnm[ FLNM_LEN ] ;
   short ext ;
   long cnt, sz ;





/*CALCULATE TOTAL SIZE OF EIGEN ENERGY VECTOR*/
   sz = 2 * J_max + 1 ;

/*ALLOCATE SPACE FOR HAMILTONIAN MATRIX*/
   hr_mat = NULL ;
   if( DAlloc1Dim( &hr_mat, sz * sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (H2V_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*REALLOCATE SPACE FOR TEMPORARY VECTOR*/
   hi_mat = NULL ;
   if( DAlloc1Dim( &hi_mat, sz * sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (H2VI_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*REALLOCATE SPACE FOR TEMPORARY VECTOR*/
   vr_mat = NULL ;
   if( DAlloc1Dim( &vr_mat, sz * sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (VR_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*REALLOCATE SPACE FOR TEMPORARY VECTOR*/
   vi_mat = NULL ;
   if( DAlloc1Dim( &vi_mat, sz * sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (VI_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*REALLOCATE SPACE FOR TEMPORARY VECTOR*/
   tau_mat = NULL ;
   if( DAlloc1Dim( &tau_mat, 2 * sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (TAU_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR TEMPORARY VECTOR*/
   od_vec = NULL ;
   if( DAlloc1Dim( &od_vec, sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (OD_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }

/*ALLOCATE SPACE FOR TEMPORARY VECTOR - NEEDED ON CERTAIN MACHINES - STRANGE ERROR RESULTS*/
   od1_vec = NULL ;
   if( DAlloc1Dim( &od1_vec, sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (OD1_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR DERIVATIVE MATRIX*/
   dvs_mat = NULL ;
   if( DAlloc1Dim( &dvs_mat, sz * St_nodv[ st ] ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (DVS_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR OFF-DIAGONAL <P+**2 + P-**2> MATRIX ELEMENTS*/
   pp2pm2_vec = NULL ;
   if( DAlloc1Dim( &pp2pm2_vec, sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (PP2PM2_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR <PX> OR <PY> MATRIX ELEMENTS*/
   if( Rc_stat[ st ][ PX ] || Rc_stat[ st ][ PY ] )
      {
      pxpy_vec = NULL ;
      if( DAlloc1Dim( &pxpy_vec, sz ) == -1 )
         {
         fprintf( Log_fp, "\nIHAMINIT (PXPY_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }
      }


/*ALLOCATE SPACE FOR <PXPZ + PZPX> OR <PYPZ + PZPY> MATRIX ELEMENTS*/
   if( Rc_stat[ st ][ PXPZ ] || Rc_stat[ st ][ PYPZ ] ||
         Tp_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PYPZ ] )
      {
      pxypz_vec = NULL ;
      if( DAlloc1Dim( &pxypz_vec, sz ) == -1 )
         {
         fprintf( Log_fp, "\nIHAMINIT (PXYPZ_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }
      }


/*CALCULATE TOTAL # OF EIGEN ENERGIES*/
   sz = J_max * (J_max + 2) + 1 ;

/*ALLOCATE SPACE FOR ALL EIGENVALUES*/
   Erg_vec[ st ] = NULL ;
   if( DAlloc1Dim( &Erg_vec[ st ], sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (ERG_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }

/*ZERO ENERGY MATRIX*/
   for( cnt = 0; cnt < sz; cnt++ )        
      *(*(Erg_vec + st) + cnt) = 0.0 ;



/*CALCULATE TOTAL # OF QUANTUM #'S*/
   sz = (J_max * (J_max + 2) + 1) ;

/*ALLOCATE SPACE FOR ALL KA QUANTUM #'S*/
   Ka_ary[ st ] = NULL ;
   if( SAlloc1Dim( &Ka_ary[ st ], sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (KA_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }

/*ALLOCATE SPACE FOR ALL KC QUANTUM #'S*/
   Kc_ary[ st ] = NULL ;
   if( SAlloc1Dim( &Kc_ary[ st ], sz ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT (KC_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }



/*MICROWAVE - SAME AS GND STATE FILESNAMES*/
   if( !Rc[ EXE ][ ORI ] )
      ext = 0 ;
   else
      ext = st ;



/*CREATE FILENAME FOR STATE EIGENVALUES*/
   strcpy( See_flnm[ st ], "SEE-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( See_flnm[ st ], end_flnm ) ;
   strcat( See_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE QUANTUM #'S*/
   strcpy( Sqn_flnm[ st ], "SQN-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sqn_flnm[ st ], end_flnm ) ;
   strcat( Sqn_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE EIGENVECTORS*/
   strcpy( Sevr_flnm[ st ], "SEVR-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sevr_flnm[ st ], end_flnm ) ;
   strcat( Sevr_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE EIGENVECTORS*/
   strcpy( Sevi_flnm[ st ], "SEVI-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sevi_flnm[ st ], end_flnm ) ;
   strcat( Sevi_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE DERIVATIVES*/
   strcpy( Sdv_flnm[ st ], "SDVR-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sdv_flnm[ st ], end_flnm ) ;
   strcat( Sdv_flnm[ st ], ".IAR" ) ;



/*MICROWAVE - SAME AS GND STATE FILES - RETURN SUCCESS*/
   if( st && !Rc[ EXE ][ ORI ] )
      return( 1 ) ;



/*CREATE FILE TO WRITE STATE EIGENVECTORS*/
   if( (evi_fd = open( Sevi_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 ) ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sevi_flnm[ st ] ) ;
      return( -1 ) ;
      }

/*CREATE FILE TO WRITE STATE EIGENVALUES*/
   if( (ee_fd = open( See_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 ) ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT -> CAN'T OPEN '%s' FILE !\n", See_flnm[ st ] ) ;
      return( -1 ) ;
      }

/*CREATE FILE TO WRITE STATE QUANTUM #'S*/
   if( (qn_fd = open( Sqn_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 ) ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sqn_flnm[ st ] ) ;
      return( -1 ) ;
      }

/*CREATE FILE TO WRITE STATE EIGENVECTORS*/
   if( (evr_fd = open( Sevr_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 ) ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sevr_flnm[ st ] ) ;
      return( -1 ) ;
      }


/*CREATE FILE TO WRITE STATE DERIVATIVES #'S*/
   if( (dv_fd = open( Sdv_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 ) ) == -1 )
      {
      fprintf( Log_fp, "\nIHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sdv_flnm[ st ] ) ;
      return( -1 ) ;
      }


/*ERROR ANALYSIS*/
   if( Err == 1 )
      {
      sz = J_max * (4 * J_max * J_max + 12 * J_max + 11) / 3 ;
      printf( "\n%s STATE EV FILE LENGTH %ld  BYTES %ld\n", St_str[ st ], sz, sz * sizeof( double ) ) ;

      sz = 2 * (J_max * (J_max + 2) + 1) ;
      printf( "%s STATE KAKC FILE LENGTH %ld  BYTES %ld\n", St_str[ st ], sz, sz * sizeof( short ) ) ;

      sz = J_max * (J_max + 2) + 1 ;
      printf( "%s STATE ERG FILE LENGTH %ld  BYTES %ld\n", St_str[ st ], sz, sz * sizeof( double ) ) ;
      fflush( stdout ) ;
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*EULER ANGLE UNITARY TRANSFORMATION OF DERIVATIVES BACK TO PAF -> [U] * [I] * [U]-1 WHERE U = [Fg]*/
short DerBackRotation( int st, double *dvp_mat, double par_mat[ 3 ][ 3 ], double dvr_mat[ 3 ][ 3 ] )
   {
   long row, col ;
   double t_mat[ 3 ][ 3 ] ;


/*ASSIGN DERIVATIVES FOR C, B AND A IN ROTATED FRAME*/
/*OFF-DIAGONAL ELEMENTS ASSIGNED IN CALLING ROUTINE*/
   dvr_mat[ 0 ][ 0 ] = *(dvp_mat + B) ;
   dvr_mat[ 1 ][ 1 ] = *(dvp_mat + C) ;
   dvr_mat[ 2 ][ 2 ] = *(dvp_mat + A) ;


/*LOOP THROUGH XYZ ROWS AND DC COLUMNS -> [XYZ] * [gF]*/
   for( col = 0; col < 3; col++ )
      for( row = 0; row < 3; row++ )
         t_mat[ col ][ row ] =
            dvr_mat[ col ][ 0 ] * par_mat[ 0 ][ row ] +
            dvr_mat[ col ][ 1 ] * par_mat[ 1 ][ row ] +
            dvr_mat[ col ][ 2 ] * par_mat[ 2 ][ row ] ;


/*LOOP THROUGH DC ROWS AND T MATRIX COLUMNS -> [gF]-1 * {[XYZ] * [gF]}*/
   for( row = 0; row < 3; row++ )
      for( col = 0; col < 3; col++ )
         dvr_mat[ col ][ row ] =
            par_mat[ 0 ][ col ] * t_mat[ 0 ][ row ] +
            par_mat[ 1 ][ col ] * t_mat[ 1 ][ row ] +
            par_mat[ 2 ][ col ] * t_mat[ 2 ][ row ] ;

/*REASSIGN DERIVATIVES FOR CONSTANTS IN THE PRINCIPAL AXIS FRAME*/
   *(dvp_mat + B) = dvr_mat[ 0 ][ 0 ] ;
   *(dvp_mat + C) = dvr_mat[ 1 ][ 1 ] ;
   *(dvp_mat + A) = dvr_mat[ 2 ][ 2 ] ;


/*RETURN SUCCESS*/
   return( 1 ) ;
   }






