/***************************************************************************
                          kstack.h  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTACK_H
#define KSTACK_H


/**
  *@author B. Heath Robinson
  */
#include "kelement.h"

class KElement;

class KStack {
private:
	KElement * baseElement;
	KElement * currentElement;
	int fact(const int x);

protected:
		void hop();

public:
	int stackHeight;

	KStack();
	KStack(KStack&);
	~KStack();
	//Stack Functions
	void pop();
	void swap();
	void push(KElement*);
	void pushCopy(KElement*);
	void clear();
	void roll(int top);
	void flip(int top);
	void floate(int element);
	void sink(int element);

	//Mathematical Functions
	
	//Binary operators
	void add();
	void subtract();
	void multiply();
	void divide();
	void power();
	void root();
	void modulous();
	void AND();
	void OR();

	//Unary Operators
	void negate();
	void inverse();
	void sine(int unit=0);
	void cosine(int unit=0);
	void tangent(int unit=0);
	void hypSine();
	void hypCosine();
	void hypTangent();
	void arcsine(int unit=0);
	void arccosine(int unit=0);
	void arctangent(int unit=0);
	void hypArcsine();
	void hypArccosine();
	void hypArctangent();
	void ln();
	void log10();
	void e2X();
	void ten2X();
	void factorial();
	void compliment();
	KElement * getBase();
};

#endif
