/***************************************************************************
                          kelement.h  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KELEMENT_H
#define KELEMENT_H


/**
  *@author B. Heath Robinson
  */
#include "kscalar.h"
#include "kcomplex.h"

class KElement {
private:
	KElement * previousElement;
	int iErrorNumber;
	char * sErrorMessage;
	void setError(int iErrorNumber);
	KScalar * scalarElement;
	KComplex * complexElement;
//	KMatrix * matrixElement;
	char elementType;

public:
	KElement();
	KElement(KElement&);
	KElement(KScalar&);
	KElement(KComplex&);
//	KElement(KMatrix * newMatrixElement);
	virtual ~KElement();
	virtual const char getType() {return elementType;};
	virtual int setElement(KScalar&);
	virtual int setElement(KComplex&);
//	virtual const int setElement(KMatrix&);		
	KElement * getPrevious() const;
	void setPrevious(KElement*);		
	int getErrorNumber() {return iErrorNumber;};
	const char * getErrorMessage() {return sErrorMessage;};
	virtual const char * getStringRepresentation(int iBase);

	//Mathematical Functions
	
	//Binary operators
	virtual void add(KElement&);
	virtual void subtract(KElement&);
	virtual void multiply(KElement&);
	virtual void divide(KElement&);
	virtual void power(KElement&);
	virtual void root(KElement&);
	virtual void modulous(KElement&);
	virtual void AND(KElement&);
	virtual void OR(KElement&);

	//Unary Operators
	virtual void negate();
	virtual void inverse();
	virtual void sine(int unit=0);
	virtual void cosine(int unit=0);
	virtual void tangent(int unit=0);
	virtual void hypSine();
	virtual void hypCosine();
	virtual void hypTangent();
	virtual void arcsine(int unit=0);
	virtual void arccosine(int unit=0);
	virtual void arctangent(int unit=0);
	virtual void hypArcsine();
	virtual void hypArccosine();
	virtual void hypArctangent();
	virtual void ln();
	virtual void log10();
	virtual void e2X();
	virtual void ten2X();
	virtual void factorial();
	virtual void compliment();
};

#endif
