/***************************************************************************
                          functions.cpp  -  description
                             -------------------
    begin                : Fri Jan 28 2000
    copyright            : (C) 2000 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "functions.h"
#include <math.h>
#include <stdlib.h>
#include <string.h>

int fact(const int x){
	if (x == 0){
		return 1;
	} else {
		return x*fact(x-1);
	}
}

double convertAngle(double dAngle, int iFromUnit, int iToUnit) {
	double convertedValue;
	switch(iFromUnit){
	case 0: convertedValue=dAngle*M_PI/180; break;//degrees
	case 1: convertedValue=dAngle; break;//radians
	case 2: convertedValue=dAngle*M_PI/200; break;//gradients
	}

	switch(iToUnit){
	case 0: convertedValue=dAngle/M_PI*180; break;//degrees
	case 1: convertedValue=dAngle; break;//radians
	case 2: convertedValue=dAngle/M_PI*200; break;//gradients
	}
	return convertedValue;
}


const char * convertToBase(double value,int iToBase){
	const char * charBuffer;
	switch(iToBase) {
		case 1:	charBuffer = new char[13];
				charBuffer = gcvt(value,12,(char*)charBuffer);
				break;
		case 0:	charBuffer = ToBinary(long(value)); break;
		case 2:	charBuffer = ToHexadecimal(long(value)); break;
	}
		
	return charBuffer;
}
const double convertFromBase(const char * value, int iFromBase){
	double newValue;

	switch(iFromBase) {
		case 1:	newValue = atof(value); break;
		case 0:	newValue = FromBinary(value); break;
		case 2:	newValue = FromHexadecimal(value); break;
	}
	return newValue;
}

const char * ToBinary(long int value){
	int j=0;
	float i;
	int workval;
	char * workString;
	char * returnString;
	workString = new char[2];
	workval=int(value);
	
	while(workval != 0){
		workval /= 2;			
		j++;
	}
	j--;
	returnString = new char[j+1];
	returnString[0]='\0';

	workval=(int)value;
	for (i=float(pow(2,j));i>=1;i=float(pow(2,j))){
		workString = gcvt(int(workval / i),1,workString);
		returnString = strcat(returnString,workString);
		workval %= (int)i;
		j--;				
	}

	delete(workString);
	return returnString;	
}

const char * ToHexadecimal(long int value){
	int j=0;
	float i;
	int workval;
	char * workString;
	char * returnString;
	workString = new char[2];
	workval=int(value);
	
	while(workval != 0){
		workval /= 16;			
		j++;
	}
	j--;
	returnString = new char[j+1];
	returnString[0]='\0';

	workval=(int)value;
	for (i=float(pow(16,j));i>=1;i=float(pow(16,j))){
		switch(int(workval/i)){
			case 15 : workString = strcpy(workString,"F");break;
			case 14 : workString = strcpy(workString,"E");break;
			case 13 : workString = strcpy(workString,"D");break;
			case 12 : workString = strcpy(workString,"C");break;
			case 11 : workString = strcpy(workString,"B");break;
			case 10 : workString = strcpy(workString,"A");break;
			default : workString = gcvt(int(workval / i),1,workString);
		}
		returnString = strcat(returnString,workString);
		workval %= (int)i;
		j--;				
	}

	delete(workString);
	return returnString;	
}
double FromBinary(const char * numString){
	double returnVal=0;
	for (int i=0;i<int(strlen(numString));i++){
			returnVal += (int(numString[i])-48)*pow(2,strlen(numString)-i-1);
	}
	return returnVal;
}
double FromHexadecimal(const char * numString){
	double returnVal=0;
	for (int i=0;i<int(strlen(numString));i++){
		switch(numString[i]){
			case 'F': returnVal += 15*pow(16,strlen(numString)-i-1);break;
			case 'E': returnVal += 14*pow(16,strlen(numString)-i-1);break;
			case 'D': returnVal += 13*pow(16,strlen(numString)-i-1);break;
			case 'C': returnVal += 12*pow(16,strlen(numString)-i-1);break;
			case 'B': returnVal += 11*pow(16,strlen(numString)-i-1);break;
			case 'A': returnVal += 10*pow(16,strlen(numString)-i-1);break;
			default :	returnVal += (int(numString[i])-48)*pow(16,strlen(numString)-i-1);
		}
	}
	return returnVal;
}