#include "pageobject.h"
#include "pageobject.moc"

#include "debug.h"
#include "tree.h"
#include "page.h"

#include <iostream.h>


PageObject::PageObject ()
{
  the_x_pos = the_y_pos = 0.0;
  the_page = 0;
  the_treeitem = 0;
}


PageObject::~PageObject ()
{
  delete the_treeitem;
}


bool PageObject::resizing ()
{
  return the_page->resizing;
}


bool PageObject::store (QFile& file)
{
  char buffer [128];
  sprintf(buffer,"%.4f %.4f\n",the_x_pos,the_y_pos);
  file.writeBlock(buffer,strlen(buffer));
  sprintf(buffer,"%i %i\n",widget()->width(),widget()->height());
  file.writeBlock(buffer,strlen(buffer));
  return true;
}


bool PageObject::restore (QFile& file)
{
  bool ok;
  char buffer [128];
  int w, h;
  file.readLine(buffer,126);
  if (file.atEnd()) return false;
  ok = (sscanf(buffer,"%f %f",&the_x_pos,&the_y_pos) == 2);
  file.readLine(buffer,126);
  if (file.atEnd()) return false;
  ok = ok && (sscanf(buffer,"%i %i",&w,&h) == 2);
  if (ok)
	widget()->resize(w,h);
  return ok;
}


TreeItem* PageObject::treeitem ()
{
  if (the_treeitem == 0) {
	the_treeitem = new TreeItem();
	the_treeitem->setPixmap(icon());
	the_treeitem->setText(description());
  }
  return the_treeitem;
}


QRect PageObject::pixel_area ()
{
  QRect area;
  double xf, yf;

  if (widget() == 0) return QRect();
  if (the_page == 0) return QRect();

  the_page->getScaleFactors(xf,yf);
  if (xf==0.0 || yf==0.0) return QRect();

  area = QRect(int(the_x_pos/xf),int(the_y_pos/yf),
			   int(widget()->width()/xf),int(widget()->height()/yf));

  IFDEBUG("korigin.page",3)
	cout << "PageObject::pixel_area() = ("
		 << area.left() << ", " << area.top() << ") to ("
		 << area.right() << ", " << area.bottom() << ")" << endl;
  ENDDEBUG;

  return area;
}


QRect PageObject::virtual_area ()
{
  QRect area;

  if (widget() == 0) return QRect();

  area = QRect(int(the_x_pos),int(the_y_pos),
			   int(widget()->width()),int(widget()->height()));

  IFDEBUG("korigin.page",3)
	cout << "PageObject::virtual_area() = ("
		 << area.left() << ", " << area.top() << ") to ("
		 << area.right() << ", " << area.bottom() << ")" << endl;
  ENDDEBUG;

  return area;
}


