#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{
FILE *cat;
char buff[1024],tmp[17];

EXEC SQL BEGIN DECLARE SECTION;
BASED_ON stars.bs_catalog bs_cat;
BASED_ON stars.name name;
BASED_ON stars.short_constellation con;
BASED_ON stars.hd_catalog hd_cat;
BASED_ON stars.ads_catalog ads_cat;
BASED_ON stars.varid varid;
BASED_ON stars.ra_hour ra_h;
BASED_ON stars.ra_minute ra_m;
BASED_ON stars.ra_second ra_s;
BASED_ON stars.right_ascension ra;
BASED_ON stars.dec_degree dec_d;
BASED_ON stars.dec_minute dec_m;
BASED_ON stars.dec_second dec_s;
BASED_ON stars.declination dec;
BASED_ON stars.visual_magnitude vis_mag;
BASED_ON stars.bv_magnitide bv_mag;
BASED_ON stars.spectrum spec;
EXEC SQL END DECLARE SECTION;


	cat=fopen("BrightStar.txt","r");
	if(!cat) return(errno);

	EXEC SQL SET TRANSACTION READ WRITE;

	for(;;)
	{
		memset(buff,0,sizeof(buff));
		if(!fgets(buff,sizeof(buff),cat)) break;

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff,4);
		bs_cat=atol(tmp);

		memset(name,0,sizeof(name));
		strncpy(name,buff+7,6);

		memset(con,0,sizeof(con));
		strncpy(con,buff+13,3);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+19,6);
		hd_cat=atol(tmp);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+26,5);
		ads_cat=atol(tmp);

		memset(varid,0,sizeof(varid));
		strncpy(varid,buff+33,8);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+44,2);
		ra_h=atol(tmp);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+47,2);
		ra_m=atol(tmp);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+50,4);
		ra_s=strtod(tmp,NULL);

		ra=((double)ra_h*360.0/24.0)+((double)ra_m/4.0)+(ra_s/4.0/60.0);
printf("ra=%d:%d,%lf\n",ra_h,ra_m,ra);
		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+56,3);
		dec_d=atol(tmp);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+60,2);
		dec_m=atol(tmp);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+63,2);
		dec_s=(double)atol(tmp);

		dec=(double)abs(dec_d)+((double)dec_m/60.0)+(dec_s/60.0/60.0);
		if(dec_d<0) dec=0.0-dec;
printf("dc=%d:%d,%lf\n",dec_d,dec_m,dec);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+67,5);
		vis_mag=strtod(tmp,NULL);

		memset(tmp,0,sizeof(tmp));
		strncpy(tmp,buff+74,5);
		bv_mag=strtod(tmp,NULL);

		memset(spec,0,sizeof(spec));
		strcpy(spec,buff+82);
/*
		printf("%d,%s\n",bs_cat,name);
*/

		EXEC SQL INSERT INTO STARS VALUES (:bs_cat,:name,:con,:hd_cat,:ads_cat,:varid,:ra_h,:ra_m,:ra_s,:ra,:dec_d,:dec_m,:dec_s,:dec,:vis_mag,:bv_mag,:spec);

	}

	EXEC SQL COMMIT WORK;

	return(0);
}

