// Emacs will be in -*- Mode: c++ -*-
//
// ********** DO NOT REMOVE THIS BANNER **********
//
// SUMMARY: Language for a Finite Element Method
// RELEASE: 2.0     
// USAGE  : You may copy freely these files and use it for    
//          teaching or research. These or part of these may   
//          not be sold or used for a commercial purpose with- 
//          out our consent : fax (33)1 44 27 44 11        
//
// AUTHORS:  D. Bernardi, Y. Darmaillac F. Hecht,    
//           P. Parole O. Pironneau C. Prud'homme
// ORG    :          
// E-MAIL :   pironneau@ann.jussieu.fr     
//
// ORIG-DATE:     June-94
// LAST-MOD:      3-Jan-96 at 13:40:55 by Prud'homme Christophe
//
// DESCRIPTION:  
// DESCRIP-END.
//

#ifndef __TRIANGUL_H
#define __TRIANGUL_H

#if !defined(TRIANGULATION_TYPEDEFS)
#define TRIANGULATION_TYPEDEFS
typedef struct
{
 float x;
 float y;
}rpoint;

typedef long triangle[3];

typedef struct
{
 long np, nt;
 rpoint *rp;
 triangle *tr;
 int* ngt;
 int* ng;
}triangulation;
#endif /* TRIANGULATION_TYPEDEFS */

int mshptg_(float *cr,float *h, long *c, long *nu, long *nbs, long nbsmx, long *tri,
    long *arete, long nba, long *sd,
    long nbsd, long *reft, long *nbt, float coef, float puis, long *err);

long MakeTriangulation( triangulation *t, long nbs, long nbsmax, long nba,
        float *cr, float *h, long *arete, int *ngbdy, long* sd, long nbsd, int* flag, int fflag );

int verifietr(float *cr, int ns);
void  removeBdyT (triangulation * t);
#endif /* __Triangul_H */
