// Emacs will be in -*- Mode: c++ -*-
//
// ********** DO NOT REMOVE THIS BANNER **********
//
// SUMMARY: Language for a Finite Element Method
// RELEASE: 2.0     
// USAGE  : You may copy freely these files and use it for    
//          teaching or research. These or part of these may   
//          not be sold or used for a commercial purpose with- 
//          out our consent : fax (33)1 44 27 44 11        
//
// AUTHORS:  D. Bernardi, Y. Darmaillac F. Hecht,    
//           P. Parole O. Pironneau C. Prud'homme
// ORG    :          
// E-MAIL :   pironneau@ann.jussieu.fr     
//
// ORIG-DATE:     June-94
// LAST-MOD:      3-Jan-96 at 13:40:55 by Prud'homme Christophe
//
// DESCRIPTION:  
// DESCRIP-END.
//

#ifndef __SYNTAXIC_H
#define __SYNTAXIC_H

#include <triangul.h>

typedef struct noeud
{
  Symbol symb;
  creal value;
  ident *name;
  long  junk;
  char  *path;
  struct noeud *l1, *l2, *l3, *l4;
} noeud, *arbre;

typedef struct
{
  ident *name, *arg1, *arg2;
  arbre def;
} fonctionrecord, *fonction;

typedef struct
{
  ident *x, *y, *cursom, *t, *ng, *region, *ne, *I, *pi, *nx, *ny;
} var;

extern int OPTION;
extern var variables;

extern void parse(char*);
void chvar(void);
arbre instruction(void);
creal eval(arbre);
void bucheron(arbre);
void libere(void);
void showtree(arbre t);
void initsyntax(); 
void libereparam(void);
void initparam();

#endif /* __SYNTAXIC_H */
