/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _Integ_h
#define _Integ_h

#include <header.hxx>


class R3 {
public:
  Scalar x[3];
  R3() {x[0]=x[1]=x[2]=0.0;}
  R3(Scalar x0,Scalar y0,Scalar z0) {x[0]=x0;x[1]=y0;x[2]=z0;}
  void set(Scalar x0, Scalar y0, Scalar z0) {
    x[0]=x0;x[1]=y0;x[2]=z0;}
};

class Integ {

  public:
       Scalar* pesos;
       R3*     puntos;
   
    Integ() {pesos=NIL; puntos=NIL;}
    void set (int); 
    void clear() {
       if (pesos) {delete[] pesos; pesos=NIL;}
       if (puntos){delete[] puntos;puntos=NIL;}
    }
    void operator delete( void* p) {
      if (p) {
       ((Integ*)p)->clear();
       delete p;
       p=NIL;
      }
    }
    ~Integ() { this->clear();}
};

#endif
