/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <integ.hxx>

void Integ::set(int NPINT) {   

       Scalar r[4];
       Scalar s[4];
       Scalar a[4];
       Scalar b[4];
       int i,j;
       int cont=0;

       if (pesos!=NIL || puntos!=NIL) this->clear();

       pesos=new Scalar[NPINT];
       puntos=new R3[NPINT];
       if (pesos==NIL || puntos==NIL) ERROR();

       switch (NPINT) {
         case 7: { // FORMULA DE INT. EXACTA PARA POL. GRAD 3. NPINT=7.
           pesos[0]=pesos[1]=pesos[2]=1.0/40.0;
           pesos[3]=pesos[4]=pesos[5]=1.0/15.0;
           pesos[6]=9.0/40.0;
           puntos[0].set(1,0,0);
           puntos[1].set(0,1,0);
           puntos[2].set(0,0,1);
           puntos[3].set(0.5,0.5,0);
           puntos[4].set(0,0.5,0.5);
           puntos[5].set(0.5,0,0.5);
           puntos[6].set(1.0/3.0,1.0/3.0,1.0/3.0);
           break;
         }
         case 16: { // FORMULA DE INT. EXACTA PARA POL. GRAD 7. NPINT=16.

             a[0]=0.1739274226;
             a[1]=0.3260725774;
             a[2]=0.3260725774;
             a[3]=0.1739274226;

             b[0]=0.1355069134;
             b[1]=0.2034645680;
             b[2]=0.1298475476;
             b[3]=0.0311809709;

             s[0]=0.0571041961;
             s[1]=0.2768430136;
             s[2]=0.5835904324;
             s[3]=0.8602401357;

             r[0]=0.0694318422;
             r[1]=0.3300094782;
             r[2]=0.6699905218;
             r[3]=0.9305681558;

             for (i=0; i<4; i++) {
               for (j=0; j<4; j++) {
                 puntos[cont].set(s[j],r[i]*(1-s[j]),1-(s[j]+r[i]*(1-s[j])));
                 pesos[cont]=a[i]*b[j];
                 cont++;
               }
             }
             break;
         }
         default: {
             cerr<<"Lo siento. No implementado."<<endl;
             exit(1);
         }
      }
  }
