/***************************************************************************
                          btextdarst.h  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BTEXTDARST_H
#define BTEXTDARST_H

/**
  *@author Heinz Schumann

 This class 'KTextDarst' create a list with two colume for german or
 english, and hebrew bibletext. The list is createt on text format. Four
 parameters regulate to designate the subject list. The results is under
 the filename 'txtdarst1.txt' saved.
 For every verse is the gematria summary present in list 'textdarst2.tab'
 saved.
*/

#include <qobject.h>

class BTxtBuch;
class BHebIdx;
class BGematria;

class BTextDarst : public QObject
{
 Q_OBJECT

 public:

/**
 The constructor
*/
	BTextDarst();

/**
 The destructor
*/
	virtual ~BTextDarst();

/**
 The methode 'lesText' opende the bookfile and write the german or english
 bibletext in left colume and the hebrew text in right colume of
'dar1.lst' as textfile. In 'dar2.lst' file is the gematria sum for
 every verse saved.
 Parameters the methode is:
 1. Bookname bibletext.
 2. Top textposition
 3. Down textposition
 4. Language  (0=german, 1=english)
*/
  bool lesText(QString, int, int , int );

 public slots:

 void slotStop();

 private:
  QString name;                   // The Bookname
  bool op;
  bool _stop;                     // Market stop

// Pointer to instance
  BGematria *gem;
  BHebIdx   *heb;
  BTxtBuch  *ger;
};

#endif



























