#ifndef QWT_SCALE_H
#define QWT_SCALE_H

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>
#include <qwt_scldraw.h>

#include "qwt_autoscl.h"

class QwtScale : public QWidget
{

    QwtScaleDraw d_scale;
    QwtScaleDiv d_sdiv;

   QRect d_scaleRect;
   
    int d_scaleOffset[2];
    int d_scaleLength;
    int d_borderDist;
    
    int d_titleOffset;
    QString d_title;
    int d_titleDist;
    QFont d_titleFont, d_font;
    QColor d_titleColor;
    int d_autoRedraw;
    int d_adjWidth;

public:

    QwtScale(QwtScaleDraw::Orientation, QWidget *parent, const char *name = 0);
    ~QwtScale();
    
    void setTitle(const char *title);
    void setScaleOffset(int start, int end);
    void setScale(const QwtScaleDiv &sd);
    
   void setBorderDist(int bd);
   void setFont(const QFont &f);
   void setTitleFont(const QFont &f);
    void setTitleColor(const QColor &c);
    void enableTitle(bool tf);
    void adjustWidth(bool tf);

    const QFont &titleFont() const;
    const QColor &titleColor() const;
    const QwtDiMap &map() const { return d_scale; }
    
    int minScaleOffset() const;
    
    QSize sizeHint() const;

   void draw(QPainter *p, QRect *r);
   void setLabelFormat(char f, int prec);
   
protected:

    void paintEvent(QPaintEvent *e);
    void resizeEvent(QResizeEvent *e);
    void scaleChange();
    void fontChange(const QFont &oldfont);
private:
   void resizeScale();
   void resizeScale(QPainter *p, QRect *r);
				  
    
};


inline const QFont& QwtScale::titleFont() const
{
    return d_titleFont;
}


inline const QColor& QwtScale::titleColor() const
{
    return d_titleColor;
}


#endif




