/**************************************************************************
 * $Id: GraphSeries.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphSeries.h"

#define Inherited GraphSeriesData

#include "GraphSeries.moc"

GraphSeries::GraphSeries
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
   setCaption( "Series properties [ ]" ); 

   button_ok->setDefault(TRUE);
   
   dset = new SeriesOptions(tab,"Options");
   ddata = new SeriesData(tab,"Data");
   dfit = new SeriesFit(tab,"Fitting");
   
   tab -> addTab(dset,"Options");
   tab -> addTab(ddata,"Data");
   tab -> addTab(dfit,"Fitting");
   
   connect(dfit,SIGNAL(update()),SLOT(passupdate()));
}


GraphSeries::~GraphSeries()
{
}


void GraphSeries::setData(SamplinCurve *crv)
{
   QString s;
   
   curve=crv;
   dset->setData(crv);
   dfit->setData(crv);
   if(crv){
      if(strlen(crv->name())!=0)
	s=QString("Series properties [")+crv->name()+"]";
      else s="Series properties [ ]";
      setCaption(s);
   }
}

void GraphSeries::ok()
{
   int ret=0;
   
   if(curve!=NULL){
      dset->loadBack();
      ret=dfit->loadBack();
      emit update();
   }
   if(ret!=-1)accept();
}

void GraphSeries::apply()
{
   
      if(curve!=NULL){
	       dset->loadBack();
	       dfit->loadBack();
	       emit update();
      }
   
}

void GraphSeries::cancel()
{
      if(curve!=NULL){
	       dset->loadOld();
	       dfit->loadOld();
	       emit update();
      }
      reject();
}

void GraphSeries::passupdate()
{
   emit update();
}
