/**************************************************************************
 * $Id: rgpib_xdr.c 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "rgpib.h"

bool_t
xdr_gpib_request(XDR *xdrs, gpib_request *objp)
{

	 register long *buf;


	 if (xdrs->x_op == XDR_ENCODE) {
	 buf = XDR_INLINE(xdrs,9 * BYTES_PER_XDR_UNIT);
	   if (buf == NULL) {
		 if (!xdr_int(xdrs, &objp->request)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->handle)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->count)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->arg)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->pad)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->ret)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->ibsta)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->iberr)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->ibcnt)) {
			 return (FALSE);
		 }

	  }
	  else {
		 IXDR_PUT_LONG(buf,objp->request);
		 IXDR_PUT_LONG(buf,objp->handle);
		 IXDR_PUT_LONG(buf,objp->count);
		 IXDR_PUT_LONG(buf,objp->arg);
		 IXDR_PUT_LONG(buf,objp->pad);
		 IXDR_PUT_LONG(buf,objp->ret);
		 IXDR_PUT_LONG(buf,objp->ibsta);
		 IXDR_PUT_LONG(buf,objp->iberr);
		 IXDR_PUT_LONG(buf,objp->ibcnt);
	  }
	 if (!xdr_string(xdrs, &objp->client, 512)) {
		 return (FALSE);
	 }
	 if (!xdr_bytes(xdrs, (char **)&objp->buf.buf_val, (u_int *)&objp->buf.buf_len, ~0)) {
		 return (FALSE);
	 }

 	 return (TRUE);
	} else if (xdrs->x_op == XDR_DECODE) {
	 buf = XDR_INLINE(xdrs,9 * BYTES_PER_XDR_UNIT);
	   if (buf == NULL) {
		 if (!xdr_int(xdrs, &objp->request)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->handle)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->count)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->arg)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->pad)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->ret)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->ibsta)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->iberr)) {
			 return (FALSE);
		 }
		 if (!xdr_int(xdrs, &objp->ibcnt)) {
			 return (FALSE);
		 }

	  }
	  else {
		 objp->request = IXDR_GET_LONG(buf);
		 objp->handle = IXDR_GET_LONG(buf);
		 objp->count = IXDR_GET_LONG(buf);
		 objp->arg = IXDR_GET_LONG(buf);
		 objp->pad = IXDR_GET_LONG(buf);
		 objp->ret = IXDR_GET_LONG(buf);
		 objp->ibsta = IXDR_GET_LONG(buf);
		 objp->iberr = IXDR_GET_LONG(buf);
		 objp->ibcnt = IXDR_GET_LONG(buf);
	  }
	 if (!xdr_string(xdrs, &objp->client, 512)) {
		 return (FALSE);
	 }
	 if (!xdr_bytes(xdrs, (char **)&objp->buf.buf_val, (u_int *)&objp->buf.buf_len, ~0)) {
		 return (FALSE);
	 }
	 return(TRUE);
	}

	 if (!xdr_int(xdrs, &objp->request)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->handle)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->count)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->arg)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->pad)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->ret)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->ibsta)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->iberr)) {
		 return (FALSE);
	 }
	 if (!xdr_int(xdrs, &objp->ibcnt)) {
		 return (FALSE);
	 }
	 if (!xdr_string(xdrs, &objp->client, 512)) {
		 return (FALSE);
	 }
	 if (!xdr_bytes(xdrs, (char **)&objp->buf.buf_val, (u_int *)&objp->buf.buf_len, ~0)) {
		 return (FALSE);
	 }
	return (TRUE);
}
