/**************************************************************************
 * $Id: scriptlcd.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SCRIPTLCD_H
#define SCRIPTLCD_H

#include <qframe.h>
#include <qbitarry.h>


class LCDisplay : public QFrame		// LCD number widget
{
    Q_OBJECT
public:
    LCDisplay( QWidget *parent=0, const char *name=0 );
    LCDisplay( uint numDigits, QWidget *parent=0, const char *name=0 );
   ~LCDisplay();

    enum SegmentStyle { Outline, Filled, Flat };
    enum Mode { HEX, DEC, OCT, BIN, SCI };

   bool    smallDecimalPoint() const;

   int	    numDigits() const;
   void    setNumDigits( int nDigits );

   int	    numDecDigits() const;
   void    setNumDecDigits( int nDigits );
   
    bool    checkOverflow( double num ) const;
    bool    checkOverflow( int	  num ) const;

    Mode mode() const;
    void    setMode( Mode );

    SegmentStyle segmentStyle() const;
    void    setSegmentStyle( SegmentStyle );

    double  value() const;
    int	    intValue() const;

public slots:
    void    display( int num );
    void    display( double num );
    void    display( const char *str );
    void    setHexMode();
    void    setDecMode();
    void    setOctMode();
    void    setBinMode();
   void setSciMode();
   void    setSmallDecimalPoint( bool );

signals:
    void    overflow();

protected:
    void    resizeEvent( QResizeEvent * );
    void    drawContents( QPainter * );

private:
    void    init();
    void    internalDisplay( const char * );
    void    drawString( const char *, QPainter &, QBitArray * = 0,
			bool = TRUE );
    void    drawDigit( const QPoint &, QPainter &, int, char, char = ' ' );
    void    drawSegment( const QPoint &, char, QPainter &, int, bool = FALSE );

    int	    ndigits, ndecdigits;
   
   double  val;
    uint    base	: 3;
    uint    smallPoint	: 1;
    uint    fill	: 1;
    uint    shadow	: 1;
    QString digitStr;
    QBitArray points;

private:	// Disabled copy constructor and operator=
    LCDisplay( const LCDisplay & ) {}
    LCDisplay &operator=( const LCDisplay & ) { return *this; }
};

inline bool LCDisplay::smallDecimalPoint() const
{ return (bool)smallPoint; }

inline int LCDisplay::numDigits() const
{ return ndigits; }


#endif // SCRIPTLCD_H
