/**************************************************************************
 * $Id: SamplinEdit.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/
#include <qpixmap.h>
#include "SamplinEdit.h"

#include "SamplinEdit.moc"

LineItem::LineItem(int l, QColor &c)
{
   d_line=l;
   d_color=c;
}
LineItem::~LineItem()
{
   
}


SamplinEdit::SamplinEdit ( class KApplication *app, QWidget* parent, const char* name )
:KEdit( app, parent, name )
{
   mypal=palette();

   setPalettePropagation(NoChildren);

   d_lines.setAutoDelete(TRUE);
//   setFillColumnMode(255,TRUE);

   setAutoIndentMode(FALSE);
   setWordWrap(FALSE);
   setFillColumnMode(0,FALSE);
}

SamplinEdit::~SamplinEdit()
{
}

QPalette &SamplinEdit::getPalette(QColor &color)
{
   QColorGroup ogp;
   ogp=mypal.normal();
   QColorGroup ngp(ogp.foreground(),ogp.background(),ogp.light(),ogp.dark(),ogp.mid(),ogp.text(),color);
   markpal.setNormal(ngp);
   ogp=mypal.disabled();
   QColorGroup dgp(ogp.foreground(),ogp.background(),ogp.light(),ogp.dark(),ogp.mid(),ogp.text(),color);
   markpal.setDisabled(dgp);
   ogp=mypal.active();
   QColorGroup agp(ogp.foreground(),ogp.background(),ogp.light(),ogp.dark(),ogp.mid(),ogp.text(),color);
   markpal.setActive(agp);   
   
   return markpal;
}

void SamplinEdit::paintCell( QPainter *painter, int row, int col)
{
   bool cflag=FALSE;
   bool autoupdate=autoUpdate();
   LineItem *li;

   li=d_lines.first();
   while(li){
      if(li->line()==row){
	 cflag=TRUE;
      }
      li=d_lines.next();
   }

   if(cflag){
      setAutoUpdate(FALSE);
      QWidget::setPalette(li->palette());
   }
   if(row==marked_line){
      setAutoUpdate(FALSE);
      QWidget::setPalette(getPalette(marked_color));
      cflag=TRUE;
   }
   
   QMultiLineEdit::paintCell(painter, row, col);
   
   if(cflag){
      QWidget::setPalette(mypal);
      setAutoUpdate(autoupdate);
   } 
   
}

void SamplinEdit::paletteChange( const QPalette &)
{
}


void SamplinEdit::addMarkedLine(int line, QColor &color)
{
   QPalette myhpal;
   LineItem *li=new LineItem(line,color);

   QColorGroup ogp;
   ogp=mypal.normal();
   QColorGroup ngp(ogp.foreground(),ogp.background(),ogp.light(),ogp.dark(),ogp.mid(),ogp.text(),color);
   myhpal.setNormal(ngp);
   ogp=mypal.disabled();
   QColorGroup dgp(ogp.foreground(),ogp.background(),ogp.light(),ogp.dark(),ogp.mid(),ogp.text(),color);
   myhpal.setDisabled(dgp);
   ogp=mypal.active();
   QColorGroup agp(ogp.foreground(),ogp.background(),ogp.light(),ogp.dark(),ogp.mid(),ogp.text(),color);
   myhpal.setActive(agp);   
   
   li->setPalette(myhpal);
   
   d_lines.insert(0,li);
   repaint();
}

void SamplinEdit::delMarkedLine(int line)
{
   LineItem *li;
   
   li=d_lines.first();
   while(li){
      if(li->line()==line){
	 d_lines.remove(li);
	 repaint();
	 return;
      }
      li=d_lines.next();
   }
   
}

void SamplinEdit::delMarkedLines(void)
{
   d_lines.clear();  
   repaint();
}

void SamplinEdit::markLine(int line, const QColor &color)
{
   
   if(marked_line!=line || marked_color!=color){
      marked_line=line;
      marked_color=color;
      repaint();
   }
}

void SamplinEdit::keyPressEvent(QKeyEvent *e)
{
   emit keyPressed();
   KEdit::keyPressEvent(e);
}


//-------------------------

int SamplinEdit::insertFile(){

   QString file_to_insert;
   
   file_to_insert=selectFile(klocale->translate("Select file to Insert"));
   
   if(file_to_insert.isEmpty()) {  /* no selection */
      return KEDIT_USER_CANCEL;
   }
   file_to_insert.detach();
   
   
   int result = loadFile(file_to_insert, OPEN_INSERT);
   
   if (result == KEDIT_OK )
     setModified();
   
   return  result;
   
}

int SamplinEdit::openFile(int mode)
{
   QString fname;
   
   int result;

    if( isModified() ) {           
      switch( QMessageBox::warning( 
			 this,
			 klocale->translate("Warning:"), 	
			 klocale->translate("The current file has been modified.\n"\
					    "Would you like to save it?"),
			 klocale->translate("Yes"),
			 klocale->translate("No"),
			 klocale->translate("Cancel"),
                                  0, 2 
			 )
	      )
	{
	case 0: // Yes or Enter

	result = doSave();

	if ( result == KEDIT_USER_CANCEL)
	  return KEDIT_USER_CANCEL;

	if (result != KEDIT_OK){

	  switch(QMessageBox::warning(
			   this,
			   klocale->translate("Sorry:"), 
			   klocale->translate("Could not save the file.\n"\
                                              "Open a new file anyways?"), 
			   klocale->translate("Yes"),
                           klocale->translate("No"),
			       "",
			       0,1
			   )
		 )
	    {

	    case 0:
	      break;
	    case 1:
	      return KEDIT_USER_CANCEL;
	      break;
	    }

	}

        break;

	case 1: // No 

	  break;
	case 2: // cancel
	  return KEDIT_USER_CANCEL;
	  break;

	}
    }
            
   fname=selectFile(klocale->translate("Select file to Open"));

   if(fname.isEmpty()) {  /* no selection */
      return KEDIT_USER_CANCEL;
   }
    
   int result2 =  loadFile(fname, mode);
   
   if ( result2 == KEDIT_OK )
      toggleModified(FALSE);
   
   return result2;
   
        
}

int SamplinEdit::newFile(){

  int result;

    if( isModified() ) {           
      switch( QMessageBox::warning( 
			 this,
			 klocale->translate("Warning:"), 	
			 klocale->translate("The current file has been modified.\n"\
					    "Would you like to save it?"),
			 klocale->translate("Yes"),
			 klocale->translate("No"),
			 klocale->translate("Cancel"),
                                  0, 2 )
	      )
	{
	
	case 0: // Yes or Enter

	  result = doSave();

	  if ( result == KEDIT_USER_CANCEL)
	    return KEDIT_USER_CANCEL;

	  if (result != KEDIT_OK){

	    switch(QMessageBox::warning(this,
			   klocale->translate("Sorry:"), 
			   klocale->translate("Could not save the file.\n"\
                                              "Create a new file anyways?"), 
			   klocale->translate("Yes"),
                           klocale->translate("No"),
			       "",
			       0,1
				      )){

	  case 0:
	    break;
	  case 1:
	    return KEDIT_USER_CANCEL;
	    break;
	  }

	}

        break;

      case 1: // No 

        break;
      case 2: // cancel
	 return KEDIT_USER_CANCEL;
	 break;

      }
    }
    

    this->clear();
    toggleModified(FALSE);

    setFocus();

    setName(klocale->translate("Untitled")+QString(SCRIPT_EXT));
       
    computePosition();
    emit(fileChanged());

    return KEDIT_OK;
            
        
}

int SamplinEdit::saveAs(){
    
  QFileInfo info;
  QString tmpfilename,fname;
  int result;

  try_again:

   fname=selectFile(klocale->translate("Save file as"));
   
   if(fname.isEmpty()){
      return KEDIT_USER_CANCEL;
   }
   
  info.setFile(fname);
  
  if(info.exists()){

    switch( QMessageBox::warning( 
			   this,
			   klocale->translate("Warning:"), 	
			   klocale->translate("A file with this name exists already\n"\
						     "Do you want to overwrite it ?"),
                           klocale->translate("Yes"),
			   klocale->translate("No"),
				  "",
                                  1, 1 )
	    ){
    case 0: // Yes or Enter
        // try again
        break;
    case 1: // No or Escape
        goto try_again;
        break;
    }
  }
  
  
  tmpfilename = getName();
  
  setName(fname);
  
  // we need this for saveFile();
  toggleModified(TRUE); 
  
  result =  saveFile();
  
  if( result != KEDIT_OK)
    setName(tmpfilename); // revert filename
  
  return result;
      
}



int SamplinEdit::doSave()
{

    
  int result = 0;
    
    if(getName() == "Untitled"+QString(SCRIPT_EXT)) {
      result = saveAs();

      if(result == KEDIT_OK)
	setCaption(getName());

      return result;
    }

    QFileInfo info(getName());

    if(info.exists() && !info.isWritable()){

      QMessageBox::warning(
			   this,
			   klocale->translate("Sorry:"), 
			   klocale->translate("You do not have write permission "\
					      "to this file.\n"),
			   klocale->translate("OK"),
			   "",
			   "",
			   0,0
			   );

      return KEDIT_NOPERMISSIONS;
    }
    

    result =  saveFile();
    return result;

}

QString SamplinEdit::selectFile(const char *caption)
{
   QFileDialog *fd;
   QString fn;
   QStrList *sl=new QStrList();
   
   sl->insert(0,"All files (*)");
   sl->insert(0,"SampLin scripts (*"SCRIPT_EXT")");
   
//   fd = new QFileDialog (cnf.root_dir+cnf.scripts_dir, "*"+QString(SCRIPT_EXT), this, caption, TRUE );
   
   fd = new QFileDialog( this, "Open file",TRUE );
   fd->setFilters(*sl);
   fd->setDir(cnf.root_dir+cnf.scripts_dir);
   fd->setCaption(caption);
   fd->show();
   if(fd->result()==QDialog::Accepted){
      fn=fd->selectedFile();
//      if(fn.find(SCRIPT_EXT,fn.length()-strlen(SCRIPT_EXT),TRUE)==-1)fn+=SCRIPT_EXT;
      if(!QFile::exists(fn))
	if(fn.find(".",fn.length()-strlen("."),TRUE)==-1)fn+=SCRIPT_EXT;
   }
   delete fd;
   delete sl;
   
   return fn;
}
