/**************************************************************************
 * $Id: Graph_series.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "Graph_series.h"
#include<stdlib.h>

#include "Graph_series.moc"

#define Inherited Graph_seriesData

Graph_series::Graph_series
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
   setCaption( "Series properties []" );
   curve=NULL;
   button_ok->setDefault(TRUE);
}


Graph_series::~Graph_series()
{
}

void Graph_series::setData(SamplinCurve *crv)
{
   QString s;

   if(crv!=NULL){
      curve=crv;
      d_name=crv->name();
      d_legend=crv->legend();
      d_xaxis=crv->xAxis()-2;
      d_yaxis=crv->yAxis();
      d_style=crv->style();
      d_color=crv->pen().color();      
      d_pwidth=crv->pen().width();
      d_pstyle=crv->pen().style();
      d_sptype=crv->splineType();
      d_spsize=crv->splineSize();
      d_sstyle=crv->symbol().style();
      d_ssize=crv->symbol().size().width();
      d_scolor=crv->symbol().pen().color();
      d_sfcolor=crv->symbol().brush().color();
      d_swidth=crv->symbol().pen().width();
      //      inp_name->setText(d_name);
      if(strlen(d_name)!=0)
	s=QString("Series properties [")+d_name+"]";
      else s="Series properties [ ]";
      setCaption(s);
      inp_legend->setText(d_legend);
      inp_xaxis->setCurrentItem(d_xaxis);
      inp_yaxis->setCurrentItem(d_yaxis);      
      inp_style->setCurrentItem(d_style);
      inp_pcolor->setColor(d_color);
      s.sprintf("%i",d_pwidth);
      inp_pwidth->setText(s);      
      inp_pstyle->setCurrentItem(d_pstyle);
      inp_sptype->setCurrentItem(d_sptype);
      s.sprintf("%i",d_spsize);
      inp_spsize->setText(s);
      inp_sstyle->setCurrentItem(d_sstyle);
      s.sprintf("%i",d_ssize);
      inp_ssize->setText(s);
      inp_scolor->setColor(d_scolor);
      inp_sfcolor->setColor(d_sfcolor);
      s.sprintf("%i",d_swidth);
      inp_swidth->setText(s);
   }
}

void Graph_series::apply()
{
   loadBack();
   emit update();
}

void Graph_series::ok()
{
   loadBack();
   emit update();
   accept();  
}

void Graph_series::loadBack()
{
   QPen pen;
   QwtSymbol sym;
   QBrush brush;
   
   if(curve!=NULL){
//      curve->setName(inp_name->text());
      curve->setLegend(inp_legend->text());
      curve->setxAxis(inp_xaxis->currentItem()+2);
      curve->setyAxis(inp_yaxis->currentItem());
      curve->setStyle((SamplinCurveData::CurveStyle)(inp_style->currentItem()));

      pen.setColor(inp_pcolor->color());
      pen.setWidth(atoi(inp_pwidth->text()));
      pen.setStyle((PenStyle)(inp_pstyle->currentItem()));
      curve->setPen(pen);      

      curve->setSplineType(inp_sptype->currentItem());
      curve->setSplineSize(atoi(inp_spsize->text()));

      sym.setStyle(inp_sstyle->currentItem());
      sym.setSize(atoi(inp_ssize->text()));
      brush.setColor(inp_sfcolor->color());
      brush.setStyle(SolidPattern);
      sym.setBrush(brush);
      pen.setColor(inp_scolor->color());
      pen.setWidth(atoi(inp_swidth->text()));
      pen.setStyle(SolidLine);
      sym.setPen(pen);
      curve->setSymbol(sym);
   }
   
}

void Graph_series::cancel()
{
   QPen pen;
   QBrush brush;
   QwtSymbol sym;
   
   curve->setLegend(d_legend);
   curve->setxAxis(d_xaxis+2);
   curve->setyAxis(d_yaxis);
   curve->setStyle((SamplinCurveData::CurveStyle)d_style);

   pen.setColor(d_color);
   pen.setWidth(d_pwidth);
   pen.setStyle((PenStyle)d_pstyle);
   curve->setPen(pen);      

   curve->setSplineType(d_sptype);
   curve->setSplineSize(d_spsize);

   sym.setStyle(d_sstyle);
   sym.setSize(d_ssize);
   brush.setColor(d_sfcolor);
   brush.setStyle(SolidPattern);
   sym.setBrush(brush);
   pen.setColor(d_scolor);
   pen.setWidth(d_swidth);
   pen.setStyle(SolidLine);
   sym.setPen(pen);
   curve->setSymbol(sym);
   
   emit update();
   reject();
}
