/**************************************************************************
 * $Id: rgpib_svc.c 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "rgpib.h"
#include <stdio.h>
#include <stdlib.h>/* getenv, exit */
#include <string.h> /* strcmp */ 
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef __STDC__
#define SIG_PF void(*)(int)
#endif

#define  rgpib_null_1          rgpib_svc_null_1
#define  rgpib_gethandle_1     rgpib_svc_gethandle_1           
#define  rgpib_dorequest_1     rgpib_svc_dorequest_1           

extern void                *rgpib_svc_null_1();
extern int                 *rgpib_svc_gethandle_1();
extern struct gpib_request *rgpib_svc_dorequest_1();




void
rgpibprog_1(struct svc_req *rqstp, register SVCXPRT *transp)
{
	union {
		gpib_request rgpib_gethandle_1_arg;
		gpib_request rgpib_dorequest_1_arg;
	} argument;
	char *result;
	xdrproc_t xdr_argument, xdr_result;
	char *(*local)(char *, struct svc_req *);

	switch (rqstp->rq_proc) {
	case RGPIB_NULL:
		xdr_argument = (xdrproc_t) xdr_void;
		xdr_result = (xdrproc_t) xdr_void;
		local = (char *(*)(char *, struct svc_req *)) rgpib_null_1_svc;
		break;

	case RGPIB_GETHANDLE:
		xdr_argument = (xdrproc_t) xdr_gpib_request;
		xdr_result = (xdrproc_t) xdr_int;
		local = (char *(*)(char *, struct svc_req *)) rgpib_gethandle_1_svc;
	   break;

	case RGPIB_DOREQUEST:
		xdr_argument = (xdrproc_t) xdr_gpib_request;
		xdr_result = (xdrproc_t) xdr_gpib_request;
		local = (char *(*)(char *, struct svc_req *)) rgpib_dorequest_1_svc;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, xdr_argument, (caddr_t) &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)((char *)&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, (caddr_t) &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}
