/***************************************************************************
                 ktsconfig.cpp  -  KTS configuration dialog
                             -------------------
    begin                : Fri Oct 6 2000
    copyright            : (C) 2000 by Arnd Fischer
    email                : lxuser@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <qstring.h>
#include <kapp.h>
#include <kfiledialog.h>
#include "ktsconfig.h"

KTSConfig::KTSConfig(QWidget *parent, const char *name) :
	QDialog(parent,name,true){

	// set up the dialog
	initDialog();
	setCaption(i18n("Configuration"));
	readConfig();

	//get configuration info
	formatCount = comboFormat->count();
	editorCount = comboEditor->count();
	viewerCount = comboDVIViewer->count();

	// connect the slots and signals
	connect(btnOK, SIGNAL(clicked()), this, SLOT(slotQuit()));
	connect(btnChooseTDir, SIGNAL(clicked()), this, SLOT(slotChooseTDir()));
	connect(comboFormat, SIGNAL(activated(const char*)),
		this, SLOT(slotFormatChoosen(const char*)));
	connect(comboEditor, SIGNAL(activated(const char*)),
		this, SLOT(slotEditorChoosen(const char*)));
	connect(comboDVIViewer, SIGNAL(activated(const char*)),
		this, SLOT(slotDVIViewerChoosen(const char*)));
}

KTSConfig::~KTSConfig(){
}

/** quit the dialog */
void KTSConfig::slotQuit(){
	done(0);
}

/** choose the template directory */
void KTSConfig::slotChooseTDir(){

	// open dialog
	QString tempDir = KFileDialog::getDirectory(0, this,
		i18n("Set Template Dir"));
	if(!tempDir.isEmpty())
		emit(signalTempDirChanged(tempDir));
}

/** the format is choosen */
void KTSConfig::slotFormatChoosen(const char* format){

	QString sigFormat(format);

	// do we have a new format?
	if(formatCount < comboFormat->count())
	{
		confPrograms.formats.append(format);
		formatCount = comboFormat->count();
		emit signalConfChanged(&confPrograms);
	}
	emit signalFormatChanged(sigFormat);
}

/** the editor was choosen */
void KTSConfig::slotEditorChoosen(const char* editor){

	QString sigEditor(editor);

	// do we have a new editor?
	if(editorCount < comboEditor->count())
	{
		confPrograms.editors.append(editor);
		editorCount = comboEditor->count();
		emit signalConfChanged(&confPrograms);
	}
	emit signalEditorChanged(sigEditor);
}

/** the dvi viewer was coosen */
void KTSConfig::slotDVIViewerChoosen(const char* viewer){

	QString sigViewer(viewer);

	// do we have a new viewer?
	if(viewerCount < comboDVIViewer->count())
	{
		confPrograms.viewers.append(viewer);
		viewerCount = comboDVIViewer->count();
		emit signalConfChanged(&confPrograms);
	}
	emit signalViewerChanged(sigViewer);
}

/** read the configuration */
void KTSConfig::readConfig(){

	// make conf instance and some vars
	KConfig *config = kapp->getConfig();
	unsigned int i, j, c;
	QString name;
	QString number;
	QString texFormat, editor, dviViewer;

	config->setGroup("Settings");
	texFormat   = config->readEntry("Format");
	editor      = config->readEntry("Editor");
	dviViewer   = config->readEntry("DVI Viewer");

	// read and display formats
	config->setGroup("Formats");
	j = config->readNumEntry("Number");
	for(i = 0; i < j; i++)
	{
		name = "Format_";
		name += number.sprintf("%d",i);
		confPrograms.formats.append(config->readEntry(name));
		comboFormat->insertItem(config->readEntry(name));

		// find current format and set it in combo
		if(config->readEntry(name) == texFormat)
			c = i;
	}
	comboFormat->setCurrentItem(c);

	// read and display editors
	config->setGroup("Editors");
	j = config->readNumEntry("Number");
	for(i = 0; i < j; i++)
	{
		name = "Editor_";
		name += number.sprintf("%d",i);
		confPrograms.editors.append(config->readEntry(name));
		comboEditor->insertItem(config->readEntry(name));

		// find current editor and set it in combo
		if(config->readEntry(name) == editor)
			c = i;
	}
	comboEditor->setCurrentItem(c);

	// read and display viewers
	config->setGroup("Viewers");
	j = config->readNumEntry("Number");
	for(i = 0; i < j; i++)
	{
		name = "Viewer_";
		name += number.sprintf("%d",i);
		confPrograms.viewers.append(config->readEntry(name));
		comboDVIViewer->insertItem(config->readEntry(name));

		// find current viewer and set it in combo
		if(config->readEntry(name) == dviViewer)
			c = i;
	}
	comboDVIViewer->setCurrentItem(c);
}
