/* split.cpp
 *
 * Andreas Wst
 *
 */

#include "split.moc"

Split::Split ( QWidget *parent, const char *name, int anz, Stock *stock [] )
                : QDialog ( parent, name, TRUE )
{
  setCaption ("Split stocks");

  gb = new QButtonGroup ("Stocks", this, "ButtonGroup_1" );
  gb->setGeometry( 20, 20, 300, 230 );
  gb->setFrameStyle( 49 );
  gb->lower();

  lb = new QListBox( gb, "ListBox_2" );
  lb->setGeometry( 20, 30, 260, 180 );
  lb->setFrameStyle( 51 );
  lb->setLineWidth( 2 );
  lb->setAutoBottomScrollBar( FALSE );

  for (int i = 0; i < anz; i++)
  {
    s [i] = stock [i];
    lb->insertItem (s [i]->getName ());
  }

  QLabel *l = new QLabel ("Split stocks in ratio", this, "Label_1" );
  l->setGeometry( 50, 270, 140, 20 );
  l->setAlignment( 289 );

  l = new QLabel ("to", this, "Label_2" );
  l->setGeometry( 240, 270, 20, 20 );
  l->setAlignment( 289 );

  sp1 = new QSpinBox (1, 20, 1, this, "SpinBox1");
  sp1->setGeometry (170, 270, 50, 20);
  
  sp2 = new QSpinBox (1, 20, 1, this, "SpinBox2");
  sp2->setGeometry (260, 270, 50, 20);


  ok = new QPushButton("OK", this, "PushButton_1" );
  ok->setGeometry( 240, 310, 80, 30 );
  connect (ok, SIGNAL (clicked ()), SLOT (okPressed ()));

  cancel = new QPushButton ("Cancel", this, "PushButton_2" );
  cancel->setGeometry( 150, 310, 70, 30 );
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));

  resize( 340, 360 );
}


Split::~Split()
{

        
}

void Split::okPressed ()
{
  int index = lb->currentItem ();

  // aktie gewhlt ?
  if (index < 0)
  {
    QMessageBox::information (this, "Error", "You have to select \n"
                              "a stock !", "&Ok");
    return;
  } 

  // zahlen in spinboxes ?
  
  bool ok = TRUE;
  QString st = sp1->text ();
  int z1 = st.toInt (&ok);

  st = sp2->text ();
  int z2 = st.toInt (&ok);
 
  if (ok == FALSE)
  {
    QMessageBox::information (this, "Error", "You have to insert numbers\n"
                              "into the SpinBoxes !", "&Ok");
    return;
  } 
  
  
  // alles richtig ! sind sie sicher
  char str [100];
  sprintf (str, "You really want to split %s  \n"
                "in ratio %d:%d ?", 
           s [index]->getName (), z1, z2);
  switch (QMessageBox::information (this, "Split", str, "&Cancel", "&Ok"))
  {
    case 0 : // cancel -> nix tun
             return;
             break;
    case 1 : // ok -> splitten
             // anzahl, kaufkurs, aktkurs splitten
             s [index]->setAnzahl (s [index]->getAnzahl () * z2 / z1);
             s [index]->setKaufKurs (s [index]->getKaufKurs () * z1 / z2);
             s [index]->setAktKurs (s [index]->getAktKurs () * z1 / z2);
             accept ();
             break;
  }

}
