/* importdlg.h
 *
 * Andreas Wst
 *
 */

#ifndef IMPORT_DIALOG_H
#define IMPORT_DIALOG_H

#include <qlabel.h>
#include <qdialog.h>
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qfiledialog.h>


#include <kmsgbox.h>

#include <stdio.h>
#include <stdlib.h>

class ImportDlg : public QDialog
{

  Q_OBJECT

public:

  ImportDlg ( QWidget *, const char *name);
  ~ImportDlg();


public slots:

  // file - dialog um importdatei auszuwhlen
  void openFileDlg ();

  // ok - pressed -> eingaben prfen, importieren
  void okPressed ();

  // bgformat clicked
  void updateFormat (int);

  // bgdate clicked
  void updateDate (int);


signals:
  
  // Dateiname, Verwaltungsname, Format und Date bergeben
  void emitData (QString, QString, unsigned char, unsigned char);



private:

protected:

  // entfernt string nachfolgende spaces
  char * removeSpaces (char *);

  QButtonGroup *bgdate;
  QButtonGroup *bgformat;
  QButtonGroup *bgimport;
  QPushButton* browse;
  QRadioButton* f1;
  QRadioButton *d1, *d2;
  QLineEdit *le;
  QComboBox *combo;
  QPushButton *cancel, *ok;

  unsigned char date, format;

};

#endif		
