/* addstock.cpp
 *
 * Andreas Wst
 *
 */

// 30 Stellen fr Firmenname 
// Firmenname startet bei 37 
// Krzel startet bei 69


#include "defines.h"

#include "addstock.moc"

AddStock::AddStock ( QWidget *parent, const char *name )
                : QDialog ( parent, name, TRUE ), selected (0), 
                  radioactivated (0)
{
  stockdata = NULL;
 
  setCaption ("Add new stock");
  debug ("in dialog");
  
  // Market Frame

  bgmarket = new QButtonGroup ("Market", this, "bgmarket");
  bgmarket->setGeometry (10, 10, 220, 80);
  bgmarket->setFrameStyle (49);
  
  combo = new QComboBox (this, "combo");
  combo->setGeometry (30, 40, 180, 30);
  combo->insertItem ("DAX");
  combo->insertItem ("M-DAX");
  combo->insertItem ("EURO-STOXX");
  combo->insertItem ("Neuer Markt");
  combo->insertItem ("Ausland");
  combo->insertItem ("Dow Jones");
  combo->insertItem ("EASDAQ");

  // Stock Frame
  
  bgstock = new QButtonGroup ("Stock", this, "bg2" );
  bgstock->setGeometry( 250, 10, 230, 160 );
  bgstock->setFrameStyle( 49 );
  bgstock->setAlignment( 1 );
  bgstock->lower();

  QLabel *l = new QLabel ("Name :", bgstock, "l1");
  l->setGeometry( 20, 30, 50, 20 );
  l->setAlignment (290);
  l->setMargin (-1);

  l = new QLabel ("WKN :", bgstock, "l2");
  l->setGeometry ( 10, 60, 60, 20 );
  l->setAlignment( 290 );
  l->setMargin( -1 );

  l = new QLabel ("Number :", bgstock, "l3");
  l->setGeometry( 20, 90, 50, 20 );
  l->setAlignment( 290 );
  l->setMargin( -1 );

  l = new QLabel ("Price :", bgstock, "l4");
  l->setGeometry( 10, 120, 60, 20 );
  l->setAlignment( 290 );
  l->setMargin( -1 );


  le [0] = new QLineEdit ( bgstock, "le1" );
  le [0]->setGeometry( 90, 30, 90, 20 );
  le [0]->setMaxLength( 50 );
  le [0]->setEchoMode( QLineEdit::Normal );
  le [0]->setFrame( TRUE );

  
  le [1] = new QLineEdit( bgstock, "le2" );
  le [1]->setGeometry( 90, 60, 90, 20 );
  le [1]->setMaxLength( 7 );
  le [1]->setEchoMode( QLineEdit::Normal );
  le [1]->setFrame( TRUE );

  
  le [2] = new QLineEdit( bgstock, "LineEdit_3" );
  le [2]->setGeometry( 90, 90, 90, 20 );
  le [2]->setMaxLength( 10 );
  le [2]->setEchoMode( QLineEdit::Normal );
  le [2]->setFrame( TRUE );

  le [3] = new QLineEdit( bgstock, "LineEdit_4" );
  le [3]->setGeometry( 90, 120, 90, 20 );
  le [3]->setMaxLength( 10 );
  le [3]->setEchoMode( QLineEdit::Normal );
  le [3]->setFrame( TRUE );
 
  // Selection Frame
 
  bgselect = new QButtonGroup ("Selection", this, "bg3");
  bgselect->setGeometry( 10, 110, 220, 230 );
  bgselect->setFrameStyle( 49 );
  bgselect->setAlignment( 1 );
  bgselect->lower();

  lb = new QListBox(bgselect, "lb" );
  lb->setGeometry( 20, 30, 180, 180 );
  lb->setFrameStyle( 51 );
  lb->setLineWidth( 2 );
  lb->setAutoBottomScrollBar (FALSE);

  connect (lb, SIGNAL (highlighted(int)), this, SLOT (getSelectedStock (int)));

  // Logo frame
  bglogo = new QButtonGroup ("Logo", this, "bg4");
  bglogo->setGeometry (250, 180, 230, 160);
  bglogo->setFrameStyle (49);
  bglogo->setAlignment (1);
  bglogo->lower ();


  cancel = new QPushButton ("Cancel", this, "cancel");
  cancel->setGeometry (250, 360, 100, 30);
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));

  ok = new QPushButton ("OK", this, "ok");
  ok->setGeometry (380, 360, 100, 30);
  connect (ok, SIGNAL (clicked ()), SLOT (okPressed ()));
  connect (this, SIGNAL (E_noErrors ()), SLOT (accept ()));

  
  connect (combo, SIGNAL (activated (int)), SLOT (comboSelected (int)));

  // Standardmig dax.list laden
  loadList ("dax.list");
  getSelectedStock (selected); 
  repaint (FALSE);

  setMaximumSize (490, 400);
  setMinimumSize (490, 400);

}

AddStock::~AddStock()
{
  if (stockdata != NULL)
  {
    delete [] stockdata;
    stockdata = NULL;
  } 
}

void AddStock::getSelectedStock (int index)
{
  char daten [79], s [50];

  strcpy (daten, stockdata [index].data ());

  // wkn auslesen 
  memset (s, 0, sizeof (s));
  memcpy (&s [0], &daten [0], 7);
  le [1]->setText (s);

  // name auslesen 
  memset (s, 0, sizeof (s));
  memcpy (&s [0], &daten [37], 30);

  // in lineedits eintragen
  le [0]->setText (s);
  le [0]->setCursorPosition (0);


  // filename des logos auslesen und in file speichern
  char dummy [20];
  memset (dummy, 0, sizeof (dummy));
  memcpy (&dummy [0], &daten [10], 19);
  debug ("----------- %sfile", dummy);
  file = "";
  file += dummy;
  file.replace (QRegExp (" "), "");
  repaint (TRUE);
}


void AddStock::okPressed ()
{
  QString n, w, s;
  int nr;
  double k;

  bool ok = TRUE;
  debug ("okpr");

  // Name holen
  n = le [0]->text ();

  // alle Leerzeichen am Ende des Strings entfernen
  while (n.find (QRegExp (" $")) != -1)
    n.replace (QRegExp (" $"), 0);

 
  // WKN holen
  w = le [1]->text ();
 
  // Anzahl holen
  s = le [2]->text ();
  nr = s.toInt (&ok);
  
  // Kaufkurs holen
  s = le [3]->text ();
  k = s.toDouble (&ok);

  if (ok == FALSE || n.length () == 0 || w.length () == 0)
  {
    KMsgBox::message (this, "Error", "Input Error !");
    return;
  }
  
  stock = new Stock (nr, n.data (), w.data (), k);
  emit (E_Stock (*stock));
  emit (E_noErrors ());
  emit (E_added (TRUE));

}


void AddStock::comboSelected (int i)
{
  radioactivated = i;
  switch (i)
  {
    case 0 : loadList ("dax.list");             
             break;
    case 1 : loadList ("mdax.list");
             break;
    case 2 : loadList ("stoxx50.list");
             break;
    case 3 : loadList ("neuermarkt.list");
             break;;
    case 4 : loadList ("ausland.list");
             break;
    case 5 : loadList ("dowjones.list");
             break;
    case 6 : loadList ("easdaq.list");
             break;
  }
  lb->setSelected (0, TRUE);
  repaint (FALSE);
}


char * AddStock::removeSpaces (char *s)
{
  int i = strlen (s) - 1;
  while (s [i] == 32 || s [i] == 13 || s [i] == 0)
  {
    s [i] = 0;
    i--;
  }
  return s;
}



void AddStock::loadList (const char *s)
{
  FILE *in;
 
  QString st (getenv ("KDEDIR"));
  st += "/share/apps/kstocks/";
  st += s;

  debug (st.data ());
  
  if ((in = fopen (st.data (), "rt")) == NULL)
  {
    fprintf (stderr, "Error opening %s !\n", st.data ());
  }
  else
  {
    lb->clear ();
    char daten [78];
    char str [78];
  
    // anzahl der zeileneintrge in der listfile ermitteln
    int i = 0;
    while (fgets (daten, 78, in) != NULL)
    {
      i++;
    }

    // dateizeiger wieder an anfang der datei stellen
    fseek (in, 0, SEEK_SET);

    // speicher fr zeileneintrage allokieren
    if (stockdata == NULL)
    {
      stockdata = new QString [i];
    }
    else
    {
      delete [] stockdata;
      stockdata = new QString [i];
    }

    // alle daten strings aus files in stockdata speichern 
    i = 0;
    while (fgets (daten, 78, in) != NULL)
    {
      stockdata [i] = daten;
      memset (str, 0, sizeof (str));
      // namen aus stockdata auslesen und in listbox eintragen
      char dummy [35];

      memcpy (str, stockdata [i].data (), 77);
      memcpy (str, &str [37], 30);
      str [30] = 0;
      //      debug ("%sohne", str);
      strcpy (dummy, removeSpaces (dummy));
      //      debug ("%smit", str);
      lb->insertItem (str);
      i++;
    }
   
  }
  lb->setSelected (selected, TRUE);
}


void AddStock::paintEvent (QPaintEvent *)
{
  QPixmap pm (205, 80);
  pm.fill (QColor (255, 255, 255));
  bitBlt (bglogo, 12, 40, &pm);

  // kdepfad holen, pfad und filename anhngen
  QString st (getenv ("KDEDIR"));
  st += "/share/apps/kstocks/logos/" + file;

  if (pm.load (st) == FALSE)
  {
    fprintf (stderr, "Error loading logo - file %s", st.data ());
  }
  else
    bitBlt (bglogo, 12 + (103 - pm.width () / 2),
                    40 + (40 - pm.height () / 2), &pm);

}

