;;
;; Use Gnuplot to plot diagrams
;;

(define (plot-cell fp buf row col)
  (if (= (get-type buf row col) EXPRESSION)
    (writes fp (get-cell row col) "\n")
    (writes fp "\n")))

; Check if the first row can be used for tics
; Yes, the heuristics are questionable
(define (is-tics buf row c1 c2)
  (let ((type (get-type buf row c1)))
    (and (<= c1 c2)
	 (or (= type LABEL)
	     (and (not (= type EXPRESSION))
		  (is-tics buf row (+ c1 1) c2))))))

; Check if the contents of the first column is likely to be titles
(define (is-titles buf r1 r2 col)
  (let ((type (get-type buf r1 col)))
    (and (<= r1 r2)
	 (or (= type LABEL)
	     (and (not (= type EXPRESSION))
		  (is-titles buf (+ r1 1) r2 col))))))

(define (plot style)
  (let ((has-tics nil) (has-titles nil)
	(pid 0)
	(c 0) (c1 0) (c2 0) (r 0) (r1 0) (r2 0)
	(fn-cmd "") (fn-output "") (fn-data "")
	(fp-cmd nil) (fp-output nil) (fp-data nil))
    (set! pid (number->string (getpid) 10))
    (set! fn-cmd (string-append "/tmp/siagplot" pid ".cmd"))
    (set! fn-output (string-append "/tmp/siagplot" pid ".ps"))
    (set! fp-cmd (fopen fn-cmd "w"))
    (writes fp-cmd "# This file is used by Siag to control Gnuplot\n")
    (writes fp-cmd "set terminal postscript\n")
    (writes fp-cmd "set output \"" fn-output "\"\n")
    (writes fp-cmd "set data style " style "\n")
    (set! r0 (position-row (get-blku)))
    (set! r1 r0)
    (set! r2 (position-row (get-blkl)))
    (set! c0 (position-col (get-blku)))
    (set! c1 c0)
    (set! c2 (position-col (get-blkl)))
    ; the case with only one line must be treated specially
    (set! has-tics (if (= c1 c2) (is-tics nil r0 c1 c2)
				 (is-tics nil r0 (+ c1 1) c2)))
    (set! has-titles (if (= r1 r2) (is-titles nil r1 r2 c0)
				   (is-titles nil (+ r1 1) r2 c0)))
    (if has-titles (set! c1 (+ c1 1)))
    (if has-tics
      (begin
        (set! r1 (+ r1 1))
        (writes fp-cmd "set xtics (")
        (set! c c1)
        (while (<= c c2)
  	  (if (> c c1) (writes fp-cmd ", "))
	  (if (get-text r0 c)
	    (writes fp-cmd "\"" (get-string r0 c) "\" "))
	  (writes fp-cmd (- c c1))
	  (set! c (+ c 1)))
        (writes fp-cmd ")\n")))
    (writes fp-cmd "plot ")
    (set! r r1)
    (while (<= r r2)
      (set! fn-data (string-append "/tmp/siagplot" pid "." (number->string r 10)))
      (set! fp-data (fopen fn-data "w"))
      (writes fp-cmd "\"" fn-data "\"")
      (if (and has-titles (get-text r c0))
	(writes fp-cmd " title \"" (get-string r c0) "\""))
      (if (< r r2)
	(writes fp-cmd ", "))
      (set! c c1)
      (while (<= c c2)
	(plot-cell fp-data nil r c)
	(set! c (+ c 1)))
      (fclose fp-data)
      (set! r (+ r 1)))
    (writes fp-cmd "\n")
    (fclose fp-cmd)
    (system "gnuplot " fn-cmd)
    (set! pid (spawn (string-append viewer-command " " fn-output)))
    (deletia-add pid fn-data)
    (deletia-add pid fn-cmd)))
;    (spawn (string-append "kghostview " fn-output))))

