
#include "ksiag_app.h"
#include "ksiag_plugin.h"
#include "ksiag_dialogs.h"
#include "plugincallbacks.h"
#include "../siag/user_interface.h"
#include <qfileinfo.h>
#include <unistd.h>

#define PLUGIN_LINK 1
#define PLUGIN_COPY 2 

static LISP plugin_register (LISP desc, LISP ext, LISP cmd)
{
    KSiagApp::pmanager()->registerHandler(get_c_string(desc), get_c_string(ext),
                       get_c_string(cmd));
    return(NIL);
}

static LISP plugin_import()
{
    insert_plugin(PLUGIN_COPY);
    return(NIL);
}

static LISP plugin_link()
{
    insert_plugin(PLUGIN_LINK);
    return(NIL);
}

static LISP plugin_delete()
{
    int i;
    buffer *buf = w_list->buf;
    i = select_plugin(buf);
    if (i == -1)
        return(NIL);
    warning("Selected Plugin ID: %d", buf->plugin[i].ph);
    warning("Selected Plugin array index: %d", i);
    KSiagApp::pmanager()->removePlugin(buf->plugin[i].ph);
    cfree(buf->plugin[i].name);
    buf->nplugin--;
    for (; i < buf->nplugin; ++i)
        buf->plugin[i] = buf->plugin[i+1];
    warning("Done removing plugin");
    KSiagApp::manager()->activeView()->resetBuffer();
    return(NIL);
}

int select_plugin(buffer *b)
{
    char *plugin[20];
    int i;
    if (b->nplugin == 0)
        return (-1);
    for (i=0; i < 20 && i < b->nplugin; ++i)
        plugin[i] = b->plugin[i].name;
    i = select_from_list("Select Plugin:", plugin, i);
    return (i);
}

void insert_plugin(int mode)
{
    int i, n;
    plugin_t plugin;
    char pn[1024], cmd[1024];
    char *p;
    KSiagPlugin *kdeplugin;
    buffer *buf = w_list->buf;

    KSiagPluginDialog *dlg = new KSiagPluginDialog(KSiagApp::pmanager());
    i = dlg->exec();
    QFileInfo info(dlg->selectedFile());
    if (i == QDialog::Rejected || info.isDir()){
        delete dlg;
        return;
    }
    //strcpy(fn, dlg->selectedFile());
    plugin_unique_name(const_cast <char *> ((const char *)info.fileName()), pn);
    if (mode == PLUGIN_COPY){
        plugin.name = cstrdup(pn);
        p = plugin_basedir(buf, NULL);
        warning("Plugin basedir: %s", plugin_basedir(buf, NULL));
        sprintf(pn, "%s/%s", p, plugin.name);
        sprintf(cmd, "(mkdir %s;cp %s %s)2>/dev/null", p,
                (const char *)dlg->selectedFile(), pn);
        system(cmd);
    }
    else{
        strcpy(pn, dlg->selectedFile());
        plugin.name = cstrdup(pn);
    }
    warning("Plugin name = %s", pn);
    kdeplugin = new KSiagPlugin();
    kdeplugin->setParentWindow(KSiagApp::manager()->activeTable()->winId());
    if (kdeplugin->start(pn) == -1){
        delete kdeplugin;
        cfree (plugin.name);
        return;
    }

    plugin.ph = KSiagApp::pmanager()->addPlugin(kdeplugin);
    warning("Plugin ID: %d", plugin.ph);
    plugin.row = w_list->point_pos.row;
    plugin.col = w_list->point_pos.col;
    plugin.displayed = 0;
    
    n = buf->nplugin++;
    buf->plugin = (plugin_t *)crealloc(buf->plugin,
                                       buf->nplugin*sizeof(plugin_t));
    buf->plugin[n] = plugin;
    KSiagApp::manager()->activeView()->resetBuffer();
    delete dlg;
}

static LISP plugin_add(LISP filename)
{
    buffer *buf = w_list->buf;
    int i = buf->nplugin++;
    char *name = get_c_string(filename);

    KSiagPlugin *kdeplugin = new KSiagPlugin();
    kdeplugin->setParentWindow(KSiagApp::manager()->activeTable()->winId());
    if (kdeplugin->start(name) == -1){
        delete kdeplugin;
        return(NIL);
    }
    buf->plugin = (plugin_t *)crealloc(buf->plugin,
                                       buf->nplugin*sizeof(plugin_t));
    buf->plugin[i].row = w_list->point_pos.row;
    buf->plugin[i].col = w_list->point_pos.col;
    buf->plugin[i].name = cstrdup(name);
    buf->plugin[i].displayed = 0;
    buf->plugin[i].ph = KSiagApp::pmanager()->addPlugin(kdeplugin);
    KSiagApp::manager()->activeView()->resetBuffer();
    return(NIL);
}

static LISP plugin_move()
{
    int i;
    buffer *buf = w_list->buf;

    i = select_plugin(buf);
    if (i == -1)
        return (NIL);
    buf->plugin[i].row = w_list->point_pos.row;
    buf->plugin[i].col = w_list->point_pos.col;
    KSiagApp::manager()->activeView()->resetBuffer();
    return(NIL);
}

static LISP plugin_export()
{
    int i;
    char fn[1024], pn[1024], cmd[1024], path[1024], fmt[80];
    buffer *buf = w_list->buf;
    i = select_plugin(buf);
    if (i == -1)
        return(NIL);
    getcwd(path, 1024);
    strcpy(fn, buf->plugin[i].name);

    if (!select_file(path, fn, NULL, fmt))
        return(NIL);
    sprintf(pn, "%s/%s", plugin_basedir(buf, NULL), buf->plugin[i].name);
    sprintf(cmd, "cp %s %s/%s", pn, path, fn);
    system(cmd);
    return(NIL);
}

int siag_plugin_start (char *fn)
{
    KSiagPlugin *plug = new KSiagPlugin();
    plug->setParentWindow(KSiagApp::manager()->activeTable()->winId());
    if (plug->start(fn) == -1){
        delete plug;
        return(-1);
    }
    return (KSiagApp::pmanager()->addPlugin(plug));
    
}

int siag_plugin_stop (int ph)
{
    return(KSiagApp::pmanager()->removePlugin(ph));
}

int siag_plugin_save (int ph, char *fn)
{
    KSiagPlugin *plug = KSiagApp::pmanager()->plugin(ph);
    if (plug){
        return(plug->save(fn));
    }
    return(0);
}

int siag_plugin_hide (int ph)
{
    KSiagPlugin *plug = KSiagApp::pmanager()->plugin(ph);
    if (plug){
        plug->hide();
        return(1);
    }
    return(0);
}

int siag_plugin_print (int ph, FILE *fp)
{
    KSiagPlugin *plug = KSiagApp::pmanager()->plugin(ph);
    if (plug){
        return(plug->print(fp));
    }
    return(0);
}

int siag_plugin_size_get (int ph, unsigned long *w, unsigned long *h)
{

    KSiagPlugin *plug = KSiagApp::pmanager()->plugin(ph);
    if (plug){
        *w = plug->sizeHint().width();
        *h = plug->sizeHint().height();
        return(1);
    }
    return(0);
}

