
#ifndef __KSIAGTABLEMANAGER_H
#define __KSIAGTABLEMANAGER_H

#include <qwidget.h>
#include "ksiag_tableview.h"
#include "ksiag_toplevel.h"

#include <stdio.h>
#include "../siag/calc.h"
extern "C" window *w_list;


/**
 * SiagWindow represents a Siag window and enforces a association between
 * specific buffers, Siag windows, and toplevel windows. Siag normally only
 * handles one buffer per window.
 */
class SiagWindow
{
public:
    SiagWindow(window *win, KSiagTopLevel *t){w=win; top=t;}
    ~SiagWindow();
    window* siagWindow(){return (w);}
    KSiagTopLevel* topLevel(){return (top);}
    void addBuffer(buffer *b){bufList.append(b);}
    bool removeBuffer(buffer *b);
    bool queryBuffer(buffer *b);
protected:
    QList<buffer> bufList;
    KSiagTopLevel *top;
    window *w;
};

/**
 * This manages a list of SiagWindows and handles both buffer and toplevel
 * widget control.
 */

class KSiagTableManager : public QObject
{
    Q_OBJECT
public:
    KSiagTableManager (QObject *parent=0, const char *name=0);
    ~KSiagTableManager();
    bool removeBuffer (buffer *b);
    bool addBuffer (window *w, buffer *b);
    KSiagTopLevel* activeTopLevel(){return(cur->topLevel());}
    KSiagTableView* activeView(){return(cur->topLevel()->view());}
    KSiagTable* activeTable(){return(cur->topLevel()->view()->table());}
    window* activeWindow(){return(cur->siagWindow());}
    // We handle dynamic menus here so changes are reflected in all windows.
    int addMenuItem (const char *menu, const char *name,
                     const char *function);
    int addSubmenu (const char *menu, const char *name);
    int addSubmenuEntry (const char *menu, const char *submenu,
                         const char *name, const char *function);
    int menuIndex (const char *name) const;
    char* menuName (int index) const;
public slots:
    void setActiveWindow (window *w);
    void addWindow (window *w);
    void removeWindow (window *w);
    void activateBuffer (KSiagTableView *top, const char *buffer);
protected:
    SiagWindow *cur;
    QList<SiagWindow> winList;
    KSiagPopupMenu *menus[11];
    
};
    

#endif

