
#include "ksiag_app.h"
#include "ksiag_pluginmanager.h"
KSiagPluginManager::KSiagPluginManager()
{
    plugins.setAutoDelete(true);
    pluginids.setAutoDelete(true);
}

KSiagPluginManager::~KSiagPluginManager()
{
    plugins.clear();
    pluginids.clear();
}

void KSiagPluginManager::registerHandler(char *desc, char *ext, char *cmd)
{
    hd_exts.append(ext);
    hd_names.append(cmd);
    hd_descs.append(desc);
}

char* KSiagPluginManager::findHandler (char *ext)
{
    return (hd_names.at(hd_exts.find(ext)));
}

int KSiagPluginManager::addPlugin(KSiagPlugin *p)
{
    plugins.append(p);
    int *id = new int;
    *id = plugins.at();
    pluginids.append(id);
    return (plugins.at());
}

int KSiagPluginManager::removePlugin(int id)
{
    int *plugid;
    for (plugid = pluginids.first(); plugid && *plugid != id;
         plugid = pluginids.next())
        ;
    if (plugid && *plugid == id){
        plugins.remove(pluginids.at());
        return (pluginids.remove());
        return(1);
    }
    else
        return (0);
    
}

KSiagPlugin* KSiagPluginManager::plugin(int id)
{
    int *plugid;
    for (plugid = pluginids.first(); plugid && *plugid != id;
         plugid = pluginids.next())
        ;
    if (plugid && *plugid == id)
        return (plugins.at(pluginids.at()));
    else
        return (0);
}
