
#include <kwm.h>
#include "ksiag_plugin.h"
#include "ksiag_app.h"
#include <qwindowdefs.h>
#include "../common/common.h"
#include "../common/cmalloc.h"
#include <X11/Xlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#define TRAILER "%%Trailer"

KSiagPlugin::KSiagPlugin (QObject *parent, const char *name)
    : QObject (parent, name)
{
    loaded = running = visible = 0;
}

KSiagPlugin::~KSiagPlugin()
{
    stop();
}

int KSiagPlugin::pluginWrite (char *buffer)
{
    int ret = write(pfd[1], buffer, strlen(buffer));
    if (ret >= 0)
        fprintf(stderr, "plugin_write(%s)\n", buffer);
    return(ret);
}

int KSiagPlugin::pluginRead (char *buffer)
{
    fd_set rfds;
    struct timeval tv;
    int retval, n;

    FD_ZERO(&rfds);
    FD_SET(qfd[0], &rfds);
    tv.tv_sec = 60;
    tv.tv_usec = 0;
    retval = select(qfd[0]+1, &rfds, NULL, NULL, &tv);
    if (!retval) return 0;
    for (n = 0; n < 1024; n++) {
        if (!read(qfd[0], buffer+n, 1)) break;
	if (buffer[n] == '\n') {
            n++;
	    break;
	}
    }
    buffer[n] = '\0';
    return n;
}

char ** KSiagPlugin::parseCmd(char *cmd, char *filename, char *name)
{
	int i = 0;
	char **argv = (char **)cmalloc(10*sizeof(char *));
	char *cmd_copy = cstrdup(cmd);
	char *p;

	for (p = strtok(cmd_copy, " \n"); p && i < 9; p = strtok(NULL, " \n")) {
            if (p[0] == '%') {
                switch (p[1]) {
                case 's':
                    argv[i++] = cstrdup(filename);
                    break;
		case 'W':
                    argv[i++] = cstrdup(name);
                    break;
		case '%':
                    argv[i++] = p+1;
                    break;
                default:
                    ;
		}
	    } else {
                argv[i++] = p;
	    }
	}
	argv[i] = NULL;
	return argv;
}



int KSiagPlugin::start (char *filename)
{
    char *cmd;
    char *ext = strrchr(filename, '.');

    if (!ext)
        ext = filename;
    else
        ++ext;
    cmd = KSiagApp::pmanager()->findHandler(ext);
    printf("Executing plugin command %s\n", cmd);
    if (pipe(pfd) == -1)
        return (-1);
    if (pipe(qfd) == -1)
        return (-1);
    pid = fork();
    if (pid == -1)
        return (-1);
    else if (pid == 0){
        char **argv;
        close(pfd[1]);
	dup2(pfd[0], 0);
	close(pfd[0]);
	close(qfd[0]);
	dup2(qfd[1], 1);
	close(qfd[1]);
        argv = parseCmd(cmd, filename, "SiAg_PlUgIn");
        execvp(argv[0], argv);
        exit(EXIT_FAILURE);
    }
    else{
        char r[1024];
        close(pfd[0]);
	close(qfd[1]);
        if (pluginRead(r) < 6 || r[0] != '2') {
            return -1;
	}
	pluginWrite("WIN\n");
	if (pluginRead(r) < 6 || r[0] != '2') {
            return -1;
	}
        victim = strtol(r+4, NULL, 16);
        printf("Victim winId = %ld.\n", victim);
	if (victim == None) {
            return -1;
	}

        int x, y;
        Window tmp = qt_xrootwin();
        unsigned int border, depth;
        XGetGeometry(qt_xdisplay(), victim, &tmp,
                     &x, &y, &w, &h, &border, &depth);
	visible = 1;
        KWM::doNotManage(KWM::title(victim));
        KWM::prepareForSwallowing(victim);
        XSync(qt_xdisplay(), False);
        XReparentWindow(qt_xdisplay(), victim, winid, 0, 0);
        hide();
    }

    return (1);
}

int KSiagPlugin::stop()
{
    char b[1024];
    pluginWrite("QUIT\n");
    pluginRead(b);
    close(pfd[1]);
    close(qfd[0]);
    kill(pid, SIGINT);
    loaded = 0;
    return 0;
}

int KSiagPlugin::load(char *filename)
{
    char cmd[1024];

    sprintf(cmd, "LOAD %s\n", filename);
    pluginWrite(cmd);
    pluginRead(cmd);	/* ignore the response for now */
    return 0;
}

int KSiagPlugin::save (char *filename)
{
    char cmd[1024];
    
    sprintf(cmd, "SAVE %s\n", filename);
    pluginWrite(cmd);
    pluginRead(cmd);	/* ignore the response for now */
    return 0;
}

char* KSiagPlugin::help()
{
    char cmd[1024];

    pluginWrite("HELP\n");
    cmd[0] = '\0';
    pluginRead(cmd);
    return cstrdup(cmd);
}

QSize KSiagPlugin::sizeHint()
{
    return(QSize(w, h));
}

void KSiagPlugin::setParentWindow(Window id)
{
    winid = id;
}

void KSiagPlugin::show()
{
    if (visible)
        hide();
    visible = 1;
    XMapWindow(qt_xdisplay(), victim);
    XSync(qt_xdisplay(), False);
}

void KSiagPlugin::hide()
{
    XUnmapWindow(qt_xdisplay(), victim);
}

void KSiagPlugin::move(int x, int y)
{
    XMoveWindow(qt_xdisplay(), victim, x, y);
}

int KSiagPlugin::print(FILE *fp)
{
    char b[1024];
    pluginWrite("PRNT\n");
    if (!pluginRead(b)){
        warning("KSiag: No print output from plugin.");
        return(1);
    }
    if (strlen(b) < 5 || b[0] != '2')
        return(1);
    while(pluginRead(b)){
        fputs(b, fp);
        if (!strncmp(b, TRAILER, strlen(TRAILER)))
            return(0);
    }
    return(1);
}


    
