// -*- C++ -*-
#ifndef _MINIBUFFER_H
#define _MINIBUFFER_H

#include <qobject.h>
#include "LString.h"

class LyXView;

///
class MiniBuffer: public QObject {
  Q_OBJECT
public:
	///
	MiniBuffer(LyXView *o);
        ~MiniBuffer(){}; 

        bool eventFilter( QObject *, QEvent * );


	///
	bool shows_no_match;

	///
	void Set(LString const& = LString(),
		 LString const& = LString(),
		 LString const& = LString(),
		 int delay_secs=6);
	/// 
	LString GetText() const { return text; }
	///
	void Init();
	///
	void ExecCommand();
	/** allows to store and reset the contents one time. Usefull
	  for status messages like "load font" (Matthias)
	  */
	void Store();
	///
	void Reset();
	///
	void Activate();
	///
	void Deactivate();

  
        void execute();

protected:
        void timerEvent( QTimerEvent * );


private:
	///
	LyXView *owner;
	///
	LString text;
	///
	LString text_stored;
	///
	LString cur_cmd;
        ///
        enum{ MAX_HISTORY = 10 };
        ///
        LString history[MAX_HISTORY];
        ///
        int history_idx, history_cnt;
        ///
        void addHistory(LString const &cmd) { 
	        if (history_cnt==0 || (history_cnt>0 && cmd!=history[history_cnt-1 % MAX_HISTORY])) {
		    history[history_cnt % MAX_HISTORY] = cmd;
		    history_cnt++;
		}
	        history_idx = history_cnt;
	}
        ///
        LString getHistory() { return history[history_idx % MAX_HISTORY]; }
};
#endif
