// -*- C++ -*-
/* This file is part of*
 * ======================================================
 *
 *           LyX, the High Level Document Processor
 * 	 
 *	    Copyright (C) 1997 LyX Team (this file was created this year)
 * 
 *======================================================*/

#ifndef _INSET_INCLUDE_H
#define _INSET_INCLUDE_H

#include "insetcommand.h"
#include "buffer.h"
#include "filetools.h"

struct LaTeXFeatures;

// Created by AAS 970521

/**  Used to include files
 */
class InsetInclude: public InsetCommand {
public:
	///
	InsetInclude(): InsetCommand("include")
	{
		flag = InsetInclude::INCLUDE;
	}
	///
	InsetInclude(LString const &,  Buffer*);
	///
	~InsetInclude();
        ///
        Inset* Clone() { return new InsetInclude (contents, master); }
	///
	Inset::Code LyxCode() const { return Inset::INCLUDE_CODE; }
	///
	void Edit(int, int);
	///
	unsigned char Editable() const
	{
		return EDITABLE;
	}
        /// With lyx3 we won't overload these 3 methods
        void Write(FILE *);
        ///
	void Read(LyXLex &);
	/// 
	int Latex(FILE *file, signed char fragile);
	///
	int Latex(LString &file, signed char fragile);
	
	///
	void Validate(LaTeXFeatures &) const;
	
        /// Input inserts anything inside a paragraph, Display can give some visual feedback
	bool Display() const { return !(isInput()); }
	///
	LString getScreenLabel() const;
	///
	void setContents(LString const & c) {
		InsetCommand::setContents(c);
		filename = MakeAbsPath(contents, 
				       OnlyPath(getMasterFilename())); 
	}
        ///
        void setFilename(LString const & n) { setContents(n); }
        ///
        LString getMasterFilename() const { return master->getFileName(); }
        ///
        LString getFileName() const { 
		return filename;
	}
        ///  In "input" mode uses \input instead of \include.
	bool isInput() const { return (bool)(flag == InsetInclude::INPUT); }
        ///  If this is true, the child file shouldn't be loaded by lyx
	bool isNoLoad() const { return (bool)(noload); }

        /**  A verbatim file shouldn't be loaded by LyX
	 *  No need to generate LaTeX code of a verbatim file
	 */ 
	bool isVerb() const;
	///
	bool isVerbVisibleSpace() const { return (bool)(flag==InsetInclude::VERBAST);}
        ///  
	bool isInclude() const { return (bool)(flag == InsetInclude::INCLUDE);}
        ///  
	void setInput();
        ///  
	void setNoLoad(bool);
        ///  
	void setInclude();
        ///  
	void setVerb();
	///
	void setVisibleSpace(bool b);
	/// return true if the file is or got loaded.
	bool loadIfNeeded() const;
private:
        ///
        enum Include_Flags {
		///
		INCLUDE=0,
		///
		VERB = 1,
		///
		INPUT = 2,
		///
		VERBAST = 3
	};
	
	///
	bool noload;
	///
        int flag;
        ///
	Buffer *master;
	///
	LString filename;
};


inline 
bool InsetInclude::isVerb() const
{
    return (bool)(flag==InsetInclude::VERB || flag==InsetInclude::VERBAST); 
}


inline
void InsetInclude::setInput()
{
	if (!isInput()) {
	    flag = InsetInclude::INPUT;
	    setCmdName("input");
	}
}


inline
void InsetInclude::setNoLoad(bool b)
{ 
		noload = b;
}


inline
void InsetInclude::setInclude()
{
	if (!isInclude()) {
	    flag = InsetInclude::INCLUDE;
	    setCmdName("include");
	}
}


inline
void InsetInclude::setVerb()
{ 
	if (!isVerb()) {
	    flag = InsetInclude::VERB;
	    setCmdName("verbatiminput");
	}
}


inline
void InsetInclude::setVisibleSpace(bool b)
{
        if (b && flag==InsetInclude::VERB) {
	    setCmdName("verbatiminput*");
	    flag = InsetInclude::VERBAST;
	} else if (!b && flag==InsetInclude::VERBAST) {
	    setCmdName("verbatiminput");
	    flag = InsetInclude::VERB;
	}
}
#endif
