/* This file is part of
 * ======================================================
 *
 *           KLyX, the KDE Document Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *                        1996-1999 LyX and KLyX Team
 * 
 *======================================================*/

// Created by Alejandro 970222

#ifndef _INSET_BIB_H
#define _INSET_BIB_H


#include "insetcommand.h"


/**
 * Used to insert citations.
 */
class InsetCitation: public InsetCommand {
public:
        ///
	InsetCitation(): InsetCommand( "cite" ) { }
	///
	InsetCitation(LString const & key, LString const & note=LString());
        ///
        Inset* Clone() {
		return new InsetCitation(contents, options);
	}
    	///
	LString getScreenLabel()const;

	/**
	 * @return We are a \cite inset.
	 */
	Inset::Code LyxCode() const {
		return Inset::CITATION_CODE;
	}

	/**
	 * Let's change.
	 */
	void Edit( int, int );

	/**
	 * Say we can be changed :-)
	 */
	unsigned char Editable() const {
		return EDITABLE;
	}
};


/**
 * Used to insert bibitem's information (key and label)
 *
 * Must be automatically inserted as the first object in a
 * bibliography paragraph. 
 */
class InsetBibKey: public InsetCommand {
public:
	///
	InsetBibKey() : InsetCommand("bibitem") {
		counter = 1;
	}
	///
	InsetBibKey(LString const & key, LString const & label=LString());
	///
	InsetBibKey(InsetBibKey const*);
	///
        Inset* Clone() { return new InsetBibKey(this); }
	/// Currently \bibitem is used as a LyX2.x command, so we need this method.
        void Write(FILE *);
	///
	LString getScreenLabel() const;

	/**
	 * @return We are a \bibitem inset.
	 */
	Inset::Code LyxCode() const {
		return Inset::BIBITEM_CODE;
	}

	/**
	 * Let's change.
	 */
	void Edit(int, int);
	///
	unsigned char Editable() const {
		return EDITABLE;
	}
	/// A user can't neither insert nor delete this inset
	bool Deletable() const {
		return false;
	}
        ///
        void setCounter(int);
        ///
        int  getCounter() const { return counter; }
	
private:
	///
        int counter;
};


/** Used to insert BibTeX's information 
 */
class InsetBibtex : public InsetCommand {
public:
	/// 
	InsetBibtex() : InsetCommand( "BibTeX" ) {
		owner = NULL;
	}
	///
	InsetBibtex(LString const& dbase, LString const& style, Buffer *);
        ///
        ~InsetBibtex();
        ///
	Inset* Clone() { return new InsetBibtex(contents, options, NULL); }
	///
	LString getScreenLabel() const;

	/**
	 * @return We are a \bibitem inset.
	 */
	Inset::Code LyxCode() const {
		return Inset::BIBTEX_CODE;
	}

	/**
	 * Let's change.
	 */
	void Edit( int, int );
	/// 
	int Latex(FILE *, signed char);
	///
	int Latex(LString &file, signed char fragile);
	///
	unsigned char Editable() const {
		return EDITABLE;
	}
        ///
        bool addDatabase(LString const&);
        ///
        bool delDatabase(LString const&);
	///
	bool Display() const { return true; }    
private:
	///
	Buffer *owner;
};


#endif


// Local Variables:
// mode: C++
// c-file-style: "Linux"
// End:
