/****************************************************************
**
** Test for QKBrowser
**
****************************************************************/

#include <qapp.h>
#include <qpushbt.h>
#include <qfont.h>
#include <qpixmap.h>
#include <qcolor.h>
#include "qkbrowser.h"
#include "browsertest.h"
#include "QKStartupScreen.h"

#include <stdio.h>

MyWidget::MyWidget( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
  setMinimumSize( 200, 120 );
  setMaximumSize( 200, 120 );
  
  quit = new QPushButton( "BrowseBox", this, "quit" );
  quit->setGeometry( 62, 40, 75, 30 );
  quit->setFont( QFont( "Times", 14 ) );
  
  connect( quit, SIGNAL(pressed()), this, SLOT(buttonclicked()) );
}


void MyWidget::buttonclicked()
{
  QKBrowseBox* browsebox = new QKBrowseBox( 7, 4 );
  browsebox->resize( 100, 100 );
  browsebox->insertItem( QString( "A" ), 0, 0 );
  browsebox->insertItem( "B", 0, 1 );
  browsebox->insertItem( "C", 0, 2 );
  browsebox->insertItem( "D", 0, 3 );
  QPixmap pixmap( 32, 32 );
  pixmap.fill( white );
  browsebox->insertItem( pixmap, 1, 0 ); 
  pixmap.fill( red );
  browsebox->insertItem( pixmap, 1, 1 ); 
  pixmap.fill( green );
  browsebox->insertItem( pixmap, 1, 2 ); 
  pixmap.fill( yellow );
  browsebox->insertItem( pixmap, 1, 3 ); 
  browsebox->insertItem( "I", 2, 0 );
  pixmap.fill( magenta );
  browsebox->insertItem( pixmap, 2, 0 ); 
  browsebox->insertItem( "J", 2, 1 );
  pixmap.fill( cyan );
  browsebox->insertItem( pixmap, 2, 1 ); 
  browsebox->insertItem( "K", 2, 2 );
  pixmap.fill( blue );
  browsebox->insertItem( pixmap, 2, 2 ); 
  browsebox->insertItem( "L", 2, 3 );
  pixmap.fill( darkYellow );
  browsebox->insertItem( pixmap, 2, 3 ); 
  browsebox->insertItem( "M", 3, 0 );
  browsebox->insertItem( "N", 3, 1 );
  browsebox->insertItem( "O", 3, 2 );
  browsebox->insertItem( "P", 3, 3 );
  browsebox->insertItem( "Q", 4, 0 );
  browsebox->insertItem( "R", 4, 1 );
  browsebox->insertItem( "S", 4, 2 );
  browsebox->insertItem( "T", 4, 3 );
  browsebox->insertItem( "U", 5, 0 );
  browsebox->insertItem( "V", 5, 1 );
  browsebox->insertItem( "W", 5, 2 );
  browsebox->insertItem( "X", 5, 3 );
  browsebox->insertItem( "Y", 6, 0 );
  browsebox->insertItem( "Z", 6, 1 );
  browsebox->insertItem( "", 6, 2 );
  browsebox->insertItem( "", 6, 3 );
  int ret = browsebox->exec( quit );
  fprintf( stderr, " Item chosen: %d\n", ret );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( quit, &ev );
  QApplication::sendEvent( quit, &mev );
  delete browsebox;
}


int main( int argc, char **argv )
{
    QApplication a( argc, argv );

	(void)new QKStartupScreen( "/home/kalle/klyx/images/koffice-intro.gif", 5 );

    MyWidget w;
    w.setGeometry( 100, 100, 200, 120 );
    a.setMainWidget( &w );
    w.show();
    return a.exec();
}
