/* -*- mode: C++; c-file-style: "GNU" -*-
 *
 * $Id: TableOfContentsDialog.h,v 1.7 1999/01/15 11:46:24 kuepper Exp $
 */

#ifndef _TABLEOFCONTENTSDIALOG_H
#define _TABLEOFCONTENTSDIALOG_H

#include <qdialog.h>

class QPushButton;
class KTreeList;
class LyXView;
class QSlider;
class QLCDNumber;

class TableOfContentsDialog : public QDialog
{
  Q_OBJECT

public:
  TableOfContentsDialog ( LyXView* view, QWidget * parent=0, 
			  const char * name=0, WFlags f=0 );
  ~TableOfContentsDialog();

  void clear();
  void insertEntry( const char* entry, int level );

public slots:
  void updateToc();
  void gotoSection();
  void select( int );

private slots:
  void leftClicked();
  void rightClicked();
  void upClicked();
  void downClicked();
  void depthChanged(int);

private:
  void generateAncestorsIfNecessary( int level );

  LyXView* _view;
  QSlider* tocdepthSL;
  QLCDNumber* tocdepthLC;
  int tocdepth;
  int* levelindices;
  int current_index;

  KTreeList* treeview;
};



#endif

/*
 * $Log: TableOfContentsDialog.h,v $
 * Revision 1.7  1999/01/15 11:46:24  kuepper
 * Made TOC inset editable to open the TableOfContents dilaog when pressed.
 * Modified TableOfContents dilaog to use a colon as additional separator of
 * label and entries content.
 *
 * Revision 1.6  1998/03/28 22:15:29  kalle
 * - Pagestyles in DocumentLayoutDialog are dynamically updated when changing text classes
 * - InsertCitationDialog starts up with correct bibliographic reference
 * - Added Goto button to DocumentStructureDialog
 *
 * Revision 1.5  1998/03/11 13:31:15  ettrich
 * Matthias:
 *
 *      - Document Structure Editor
 *
 *      - cut and paste via qclipboard (only from outside to lyx)
 *
 * Revision 1.4  1998/03/02 21:13:56  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.3  1998/01/27 20:43:00  kalle
 * Implemented new find and replace dialog
 * 1839 XForms calls left!
 *
 * Revision 1.2  1998/01/24 22:20:58  kalle
 * toc dialog now supports up/down/left/right (currently works in
 * the dialog only, not in reality...)
 *
 * Revision 1.1  1998/01/24 21:41:18  kalle
 * TableOfContents dialog works with updating and selectinTableOfContents dialog works with updating and selectingg
 */
