/*
 * $Id: SpellCheckDialog.h,v 1.2 1998/03/04 21:49:51 kalle Exp $
 */

#ifndef _SPELLCHECKDIALOG_H
#define _SPELLCHECKDIALOG_H

#include <qdialog.h>
#include <qprogbar.h>
#include <qlined.h>
#include <qlistbox.h>

class QPushButton;

class LyXView;

class SpellCheckDialog : public QDialog
{
  Q_OBJECT

public:
  SpellCheckDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
				 WFlags f=0 );

  void reset();

  // flags
  void clearFlags();
  bool isStop() const { return bStop; }
  bool isClose() const { return bClose; }
  bool isInsert() const { return bInsert; }
  bool isIgnore() const { return bIgnore; }
  bool isReplace() const { return bReplace; }
  bool isAccept() const { return bAccept; }

  // progress bar
  void setProgressValue( int value ) { progressPB->setProgress( value ); }

  // text fields
  void setUnknownText( const char* text ) { unknownED->setText( text ); }
  void setReplaceText( const char* text ) { replaceED->setText( text ); }
  QString replaceText() const { return replaceED->text(); }

  // listbox
  void clearAlternatives() { alternativesLB->clear(); }
  void addAlternative( const char* text ) { alternativesLB->insertItem( text ); }

private slots:
  void start();
  void stop();
  void accept();
  void insert();
  void ignore();
  void replace();
  void close();
  void options();
  void listBoxHighlighted( int );
  void listBoxSelected( int );

private:
  LyXView* _view;
  bool bStop;
  bool bClose;
  bool bIgnore;
  bool bReplace;
  bool bInsert;
  bool bAccept;
  bool bIsRunning;
  
  QLineEdit* unknownED;
  QLineEdit* replaceED;
  QListBox* alternativesLB;
  
  QPushButton* startPB;
  QPushButton* insertPB;
  QPushButton* acceptPB;
  QPushButton* replacePB;
  QPushButton* ignorePB;
  QPushButton* stopPB;
  QPushButton* optionsPB;
  QPushButton* closePB;;

  QProgressBar* progressPB;
};

#endif

/*
 * $Log: SpellCheckDialog.h,v $
 * Revision 1.2  1998/03/04 21:49:51  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/01/18 14:35:13  kalle
 * Kalle:
 * - spellchecker works fine now :-)
 * - fixed bug with table menu (showed "Insert Table" too often)
 *
 */
