// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
*        
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#ifndef _SPACING_H
#define _SPACING_H

///
class Spacing {
public:
	///
	enum Space {
		///
		Single,
		///
		Onehalf,
		///
		Double,
		///
		Other,
		///
		LayoutDefault
	};
	///
	Spacing(Spacing::Space sp = Single)
	{
		space = sp;
		value = getValue();
	}
	///
	float getValue(float val = -1) const
	{
		switch(space) {
		case Single: return 1.0;
		case Onehalf: return 1.25;
		case Double: return 1.667;
		case Other: return value;
		case LayoutDefault:
		  if (val < 0)
		    return 1.0;
		  else
		    return val;
		}
		return 1.0;
	}
	///
	Spacing::Space getSpace() const
	{
		return space;
	}
	///
	void set(Spacing::Space sp, float val= 1.0)
	{
		space = sp;
		if (sp == Other) {
		  if (val <= 0)
		    val = 1.0;
		  switch(int(val*1000 + 0.5)) {
		  case 1000: space = Single; break;
		  case 1250: space = Onehalf; break;
		  case 1667: space = Double; break;
		  default: value = val; break;
		  }
		}
	}
	///
	void writeFile(FILE *file);
	///
	friend bool operator!=(Spacing const &a, Spacing const &b)
	{
		return !(a.space == b.space && a.getValue() == b.getValue());
	}

	friend bool operator==(Spacing const &a, Spacing const &b)
	{
		return (a.space == b.space && a.getValue() == b.getValue());
	}

	///
	bool isLayoutDefault(){
	  return space == LayoutDefault;
	}
    


private:
	///
	Space space;
	///
	float value;
};

#endif
