/* -*- mode: C++; c-file-style: "Stroustrup" -*-
 *
 * This file is part of KLyX, the High Level Word Processor
 *
 * Copyright (C) 1997-1999 Matthias Ettrich and the KLyX team
 */


#ifndef KLYX_SCREENTOOLBARSDIALOG_H
#define KLYX_SCREENTOOLBARSDIALOG_H


#include <qwidget.h>


class QComboBox;
struct ScreenToolbarsDialogData;



class ScreenToolbarsDialog : public QWidget
{
    Q_OBJECT

public:

    /**
     * The possible visibility states
     */
    enum Visibility { ALWAYS_VISIBLE=0, NEVER_VISIBLE, AUTOMATIC };

    ScreenToolbarsDialog ( QWidget *parent=0, const char *name=0, WFlags f=0 );

    void setData( ScreenToolbarsDialogData* data );

    ScreenToolbarsDialogData* data() const; 

    
protected:
    
    QComboBox* generalCB;
    QComboBox* mathCB;
    QComboBox* tablesCB;
    QComboBox* characterCB;
};



struct ScreenToolbarsDialogData
{
    ScreenToolbarsDialog::Visibility general_toolbar;
    ScreenToolbarsDialog::Visibility math_toolbar;
    ScreenToolbarsDialog::Visibility tables_toolbar;
    ScreenToolbarsDialog::Visibility character_toolbar;
};



#endif
