/*
 * $Id: ScreenFontsDialog.C,v 1.5 1999/01/05 11:16:48 kulow Exp $
 */

#include "ScreenFontsDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qlined.h>
#include <qlabel.h>
#include <qpushbt.h>

#include "klyx.h"

ScreenFontsDialog::ScreenFontsDialog( QWidget * parent=0, 
										  const char * name=0, 
										  WFlags f=0 ) :
  QWidget( parent, name, f )
{
  QLabel* romanLA = new QLabel( i18n( "Roman Font" ), this );
  romanLA->setGeometry( 10, 10, 110, 30 );
  romanLA->setAlignment( AlignRight | AlignVCenter );

  romanED = new QLineEdit( this );
  romanED->setGeometry( 130, 10, 200, 30 );
  romanED->setText( "-*-utopia" );

  QLabel* sansserifLA = new QLabel( i18n( "Sans Serif Font" ), 
									this );
  sansserifLA->setGeometry( 10, 48, 110, 30 );
  sansserifLA->setAlignment( AlignRight | AlignVCenter );

  sansserifED = new QLineEdit( this );
  sansserifED->setGeometry( 130, 48, 200, 30 );
  sansserifED->setText( "-*-helvetica" );
  
  QLabel* typewriterLA = new QLabel( i18n( "Typewriter Font" ), 
									 this );
  typewriterLA->setGeometry( 10, 86, 110, 30 );
  typewriterLA->setAlignment( AlignRight | AlignVCenter );

  typewriterED = new QLineEdit( this );
  typewriterED->setGeometry( 130, 86, 200, 30 );
  typewriterED->setText( "-*-courier" );

  QLabel* fontnormLA = new QLabel( i18n( "Font Norm" ), this );
  fontnormLA->setGeometry( 10, 124, 90, 30 );
  fontnormLA->setAlignment( AlignRight | AlignVCenter );

  fontnormED = new QLineEdit( this );
  fontnormED->setGeometry( 110, 124, 90, 30 );
  fontnormED->setText( DEFCHSET );

  QLabel* fontzoomLA = new QLabel( i18n( "Font Zoom" ), this );
  fontzoomLA->setGeometry( 210, 124, 100, 30 );
  fontzoomLA->setAlignment( AlignRight | AlignVCenter );

  fontzoomED = new QLineEdit( this );
  fontzoomED->setGeometry( 320, 124, 50, 30 );
  fontzoomED->setText( "150" );
}


void ScreenFontsDialog::setData( ScreenFontsDialogData* data )
{
  romanED->setText( data->roman_font );
  sansserifED->setText( data->sans_serif_font );
  typewriterED->setText( data->typewriter_font );
  fontnormED->setText( data->font_norm );
  fontzoomED->setText( data->font_zoom );
}


static ScreenFontsDialogData tempdata;

ScreenFontsDialogData* ScreenFontsDialog::data() const
{
  tempdata.roman_font = romanED->text();
  tempdata.sans_serif_font = sansserifED->text();
  tempdata.typewriter_font = typewriterED->text();
  tempdata.font_norm = fontnormED->text();
  tempdata.font_zoom = fontzoomED->text();

  return &tempdata;
}


/*
 * $Log: ScreenFontsDialog.C,v $
 * Revision 1.5  1999/01/05 11:16:48  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.4  1998/05/17 15:58:03  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.3  1998/03/04 21:49:41  kalle
 * More Qt-ified
 *
 * Revision 1.2  1998/01/07 21:04:33  kalle
 * Towards a general customization
 *
 * Revision 1.1  1998/01/02 22:23:33  kalle
 * Kalle:
 * - new images for the binary relations math browser
 * - implemented the bianry relations math browser (still buggy)
 * - started the tab dialog for ScreenOptions
 *
 * Revision 1.1  1997/12/26 22:39:58  kalle
 * Kalle:
 * - Changed ScreenOptions dialog to KDE/Qt version
 * - Changed SpellcheckerOptions dialog to KDE/Qt version
 * - Removed old toolbar
 *
 */
