/* This file is Copyright (C) 1998 Matthias Kalle Dalheimer (kalle@kde.org)

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
/*
 * $Id: QKStartupScreen.C,v 1.1 1998/01/29 21:26:26 kalle Exp $
 */

#include "QKStartupScreen.h"
#include <qapp.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qtimer.h>

#include <stdio.h>

QKStartupScreen::QKStartupScreen( const char* pixmapname, int seconds ) :
  QWidget( 0, "Startup Screen", WStyle_NoBorder | WStyle_Customize )
{
  if( !pixmap.load( pixmapname ) )
	{
	  debug( "Could not find startup pixmap" );
	}

  resize( pixmap.size() );
  move( (QApplication::desktop()->width()-pixmap.width())/2,
		(QApplication::desktop()->height()-pixmap.height())/2 );
  label = new QLabel( this );
  label->setPixmap( pixmap );
  label->resize( pixmap.size() );

  timer = new QTimer( this );
  connect( timer, SIGNAL( timeout() ), this, SLOT( destroy() ) );
  timer->start( seconds*1000, true );
  show();
}


void QKStartupScreen::destroy()
{
  if( timer->isActive() ) // happens if destroy was called explicitly
	timer->stop();
  hide();
  delete this;
}


QKStartupScreen::~QKStartupScreen()
{
  delete label;
  delete timer;
}


/*
 * $Log: QKStartupScreen.C,v $
 * Revision 1.1  1998/01/29 21:26:26  kalle
 * Added startup screen
 *
 */
