/* -*- mode: C++; c-file-style: "GNU" -*-
 *
 * $Id: LaTeXOptionsDialog.C,v 1.11 1998/09/10 06:56:53 kalle Exp $
 */


#include "LaTeXOptionsDialog.h"
#include "LyXView.h"
#include "BufferView.h"

#include <qchkbox.h>
#include <qpushbt.h>
#include <qlayout.h>

#include "BufferView.h"

#include <kbuttonbox.h>
#include <klocale.h>
#include "BufferView.h"


LaTeXOptionsDialog::LaTeXOptionsDialog( LyXView* view, QWidget * parent,
					const char * name, WFlags f )
  : QDialog( parent, name, true, f ),
    _view( view )
{
  setCaption( i18n( "LaTeX Options" ) );
  QVBoxLayout *layout = new QVBoxLayout( this, 10, 5 );
  allowCB = new QCheckBox( i18n( "Allo&w accents on ALL characters" ), this );
  allowCB->setMinimumSize( allowCB->sizeHint() );
  layout->addWidget( allowCB );
  layout->addSpacing( 5 );
  KButtonBox *bbox = new KButtonBox( this );
  bbox->addStretch( 5 );
  QPushButton* okPB = bbox->addButton( i18n( "OK" ) );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );
  bbox->addStretch( 10 );
  QPushButton* cancelPB = bbox->addButton( i18n( "Cancel" ) );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );
  bbox->addStretch( 5 );
  bbox->layout();
  layout->addWidget( bbox );
  layout->activate();
  resize( sizeHint() );
  return;
}



void LaTeXOptionsDialog::okClicked()
{
  _view->currentBuffer()->params.allowAccents = true;
  accept();
  return;
}



void LaTeXOptionsDialog::setAllowAccents( bool allow )
{
  allowCB->setChecked( allow );
  return;
}
