#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h>
#include "buffer.h"
#include "lyx_main.h"
#include "LString.h"
#include "filetools.h"
#include "pathstack.h"
#include "lyxrc.h"
#include "BufferView.h"
#include "ViewLogfileDialog.h"
#include "LyXView.h"

// 	$Id: LaTeXLog.C,v 1.3 1998/02/08 21:30:47 kalle Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: LaTeXLog.C,v 1.3 1998/02/08 21:30:47 kalle Exp $";
#endif /* lint */

/* Prototypes */
extern BufferView *current_view;

void ShowLatexLog()
{
    LString
        filename, fname, path;

    filename = current_view->currentBuffer()->getFileName();
    if (!filename.empty()) {
	fname = SpaceLess(ChangeExtension(filename, ".log", true));
	path = OnlyPath(filename);
	if (lyxrc->use_tempdir || (IsDirWriteable(path) < 1)) {
		path = current_view->currentBuffer()->tmppath;
	}
	PathPush(path); // path to LaTeX file
    }

	if( !klyxdialogs->viewlogfile )
	  {
		klyxdialogs->viewlogfile = new ViewLogfileDialog( current_view->getOwner() );
	  }

	klyxdialogs->viewlogfile->loadFile( fname.c_str() );
	ViewLogfileDialog* temp = klyxdialogs->viewlogfile;
	klyxdialogs->viewlogfile->exec();
	klyxdialogs->viewlogfile = temp;

    if (!filename.empty())
        PathPop();
}

