/*
 * $Id: KeyboardOptionsDialog.h,v 1.2 1998/03/04 21:49:24 kalle Exp $
 */

#ifndef _KEYBOARDDIALOG_H
#define _KEYBOARDDIALOG_H

#include <qdialog.h>

class QComboBox;
class QLabel;
class QLineEdit;
class QRadioButton;

class LyXView;
class Intl;

class KeyboardOptionsDialog : public QDialog
{
  Q_OBJECT

public:
  KeyboardOptionsDialog ( LyXView* view, QWidget * parent=0, 
						  const char * name=0, 
						  WFlags f=0 );

  void setKeymapButtons( bool, bool, bool );
  void setNoKeymapButton();
  void hideError();
  void showError();
  QString getPrimaryLanguage() const;
  QString getPrimaryOther() const;
  int getPrimaryCode() const;
  QString getSecondaryLanguage() const;
  QString getSecondaryOther() const;
  int getSecondaryCode() const;
  void setIntl( Intl* _intl ) { intl = _intl; }
  void setCharset( const char* );
  void insertPrimaryLanguage( const char* );
  void insertSecondaryLanguage( const char* );
  bool isInPrimary( const char* ) const;
  bool isInSecondary( const char* ) const;
  void setCurrentPrimary( int );
  void setCurrentSecondary( int );
  void setPrimaryOther( const char* );
  void setSecondaryOther( const char* );

public slots:
  void primaryKeymapToggled( bool );

private slots:
  void okClicked();
  void cancelClicked();
  void setCharsetClicked();
  void keymapOffToggled( bool );
  void secondaryKeymapToggled( bool );
  void primaryLanguageSelected( int );
  void secondaryLanguageSelected( int );

private:
  LyXView* _view;
  Intl* intl;

  QComboBox* primaryCB;
  QLineEdit* primaryotherED;
  QComboBox* secondaryCB;
  QLineEdit* secondaryotherED;

  QLabel* errorLA;

  QRadioButton* nokeymappingRB;
  QRadioButton* primarykeymapRB;
  QRadioButton* secondarykeymapRB;

  QLineEdit* charactersetED;
};

#endif

/*
 * $Log: KeyboardOptionsDialog.h,v $
 * Revision 1.2  1998/03/04 21:49:24  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/08 10:36:23  kalle
 * - added KeyboardOptionsDialog
 * - integrated KeyboardOptionsDialog into Intl class
 * - removed old combo box (finally!)
 *
 */
